#ifndef KS_MAIN_H
#define KS_MAIN_H

#include "common/main.h"
#include "common/factory.h"
#include "ai.h"
#include "settings.h"
#include "board.h"
#include "field.h"


//-----------------------------------------------------------------------------
class KSFactory : public CommonFactory
{
 public:
   KSFactory();

 protected:
    virtual BaseBoard *createBoard(bool graphic, TQWidget *parent)
        { return new KSBoard(graphic, parent); }
    virtual BaseField *createField(TQWidget *parent)
        { return new KSField(parent); }
    virtual BaseInterface *createInterface(TQWidget *parent);
    virtual AI *createAI() { return new KSAI; }
    virtual TQWidget *createGameConfig() { return new KSGameConfig; }
};

//-----------------------------------------------------------------------------
class KSMainWindow : public MainWindow
{
 Q_OBJECT
 public:
    KSMainWindow() { init(); }
};

#endif
