/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#include <tqpushbutton.h>
#include <tqlayout.h>

#include <kglobal.h>
#include <klocale.h>

#include "betbox.h"


BetBox::BetBox(TQWidget* parent, const char* name)
  : TQGroupBox(parent, name)
{
  TQVBoxLayout* topLayout = new TQVBoxLayout(this, 1, 1);
  TQGridLayout* g = new TQGridLayout(topLayout, 2, 2, 1);
  TQHBoxLayout* l = new TQHBoxLayout(topLayout, 1);

  bet5Up = new TQPushButton(this);
  g->addWidget(bet5Up, 0, 0);
  bet10Up = new TQPushButton(this);
  g->addWidget(bet10Up, 0, 1);
  bet5Down = new TQPushButton(this);
  g->addWidget(bet5Down, 1, 0);
  bet10Down = new TQPushButton(this);
  g->addWidget(bet10Down, 1, 1);

  adjustBet = new TQPushButton(this);
  l->addWidget(adjustBet, 0);
  l->addStretch(1);
  foldButton = new TQPushButton(this);
  l->addWidget(foldButton, 0);

  bet5Up->setText(TQString("+%1").arg(KGlobal::locale()->formatMoney(5)));
  bet10Up->setText(TQString("+%1").arg(KGlobal::locale()->formatMoney(10)));
  bet5Down->setText(TQString("-%1").arg(KGlobal::locale()->formatMoney(5)));
  bet10Down->setText(TQString("-%1").arg(KGlobal::locale()->formatMoney(10)));
  adjustBet->setText(i18n("Adjust Bet"));
  foldButton->setText(i18n("Fold"));

  //connects
  connect(bet5Up,     TQT_SIGNAL(clicked()), TQT_SLOT(bet5UpClicked()));
  connect(bet10Up,    TQT_SIGNAL(clicked()), TQT_SLOT(bet10UpClicked()));
  connect(bet5Down,   TQT_SIGNAL(clicked()), TQT_SLOT(bet5DownClicked()));
  connect(bet10Down,  TQT_SIGNAL(clicked()), TQT_SLOT(bet10DownClicked()));
  connect(foldButton, TQT_SIGNAL(clicked()), TQT_SLOT(foldClicked()));
  connect(adjustBet,  TQT_SIGNAL(clicked()), TQT_SLOT(adjustBetClicked()));

  stopRaise();
}


BetBox::~BetBox()
{
  delete bet5Up;
  delete bet10Up;
  delete bet5Down;
  delete bet10Down;
  delete adjustBet;
  delete foldButton;
}


void BetBox::bet5UpClicked()
{
  emit betChanged(5);
}

void BetBox::bet10UpClicked()
{
  emit betChanged(10);
}

void BetBox::bet5DownClicked()
{
  emit betChanged(-5);
}

void BetBox::bet10DownClicked()
{
  emit betChanged(-10);
}


void BetBox::adjustBetClicked()
{
  emit betAdjusted();
}


void BetBox::foldClicked()
{
  emit fold();
}


void BetBox::beginRaise()
{
  adjustBet->setEnabled(true);
  foldButton->setEnabled(true);

  bet5Up->setEnabled(false);
  bet10Up->setEnabled(false);
  bet5Down->setEnabled(false);
  bet10Down->setEnabled(false);
}


void BetBox::stopRaise()
{
  adjustBet->setEnabled(false);
  foldButton->setEnabled(false);
 
  bet5Up->setEnabled(true);
  bet10Up->setEnabled(true);
  bet5Down->setEnabled(true);
  bet10Down->setEnabled(true);
}


#include "betbox.moc"
