#include <tqbrush.h>
#include <tqcolor.h>
#include <tqcanvas.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqslider.h>

#include <klocale.h>
#include <klibloader.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kconfig.h>

#include "test.h"

K_EXPORT_COMPONENT_FACTORY(libkolftest, TestFactory)
TQObject *TestFactory::createObject (TQObject * /*parent*/, const char * /*name*/, const char * /*classname*/, const TQStringList & /*args*/)
{ return new TestObj; }

Test::Test(TQCanvas *canvas)
	: TQCanvasEllipse(60, 40, canvas), count(0), m_switchEvery(20)
{
	// force to the bottom of other objects
	setZ(-100000);

	// we want calls to advance() even though we have no velocity
	setAnimated(true);
}

void Test::advance(int phase)
{
	TQCanvasEllipse::advance(phase);

	// phase is either 0 or 1, only calls with 1 should be handled
	if (phase == 1)
	{
		// this makes it so the body is called every
		// m_switchEvery times
		if (count % m_switchEvery == 0)
		{
			// random color
			const TQColor myColor((QRgb)(kapp->random() % 0x01000000));

			// set the brush, so our shape is drawn
			// with the random color
			setBrush(TQBrush(myColor));

			count = 0;
		}

		count++;
	}
}

void Test::save(KConfig *cfg)
{
	// save our option from the course
	// (courses are represented as KConfig files)
	cfg->writeEntry("switchEvery", switchEvery());
}

void Test::load(KConfig *cfg)
{
	// load our option
	setSwitchEvery(cfg->readNumEntry("switchEvery", 50));
}

TestConfig::TestConfig(Test *test, TQWidget *parent)
	: Config(parent), m_test(test)
{
	TQVBoxLayout *layout = new TQVBoxLayout(this, marginHint(), spacingHint());

	layout->addStretch();

	layout->addWidget(new TQLabel(i18n("Flash speed"), this));

	TQHBoxLayout *hlayout = new TQHBoxLayout(layout, spacingHint());
	TQLabel *slow = new TQLabel(i18n("Slow"), this);
	hlayout->addWidget(slow);
	TQSlider *slider = new TQSlider(1, 100, 5, 101 - m_test->switchEvery(), Qt::Horizontal, this);
	hlayout->addWidget(slider);
	TQLabel *fast = new TQLabel(i18n("Fast"), this);
	hlayout->addWidget(fast);

	layout->addStretch();

	connect(slider, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(switchEveryChanged(int)));
}

void TestConfig::switchEveryChanged(int news)
{
	// update our object
	m_test->setSwitchEvery((101 - news));

	// tells Kolf the hole was modified
	changed();
}

Config *Test::config(TQWidget *parent)
{
	return new TestConfig(this, parent);
}

#include "test.moc"
