#ifndef KOLF_H
#define KOLF_H

#include <kmainwindow.h>
#include <kurl.h>

#include <tqmap.h>
#include <tqptrlist.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqvaluelist.h>
#include <kdemacros.h>
#include "game.h"

class KolfGame;
class KToggleAction;
class KListAction;
class KAction;
class TQGridLayout;
class ScoreBoard;
class TQCloseEvent;
class TQEvent;
class Player;
class TQWidget;
class Editor;

class KDE_EXPORT Kolf : public KMainWindow
{
	Q_OBJECT

public:
	Kolf();
	~Kolf();

	void openURL(KURL url);

public slots:
	void closeGame();
	void updateModified(bool);

protected:
	virtual bool queryClose();

protected slots:
	void startNewGame();
	void loadGame();
	void tutorial();
	void newGame();
	void save();
	void saveAs();
	void saveGame();
	void saveGameAs();
	void print();
	void newPlayersTurn(Player *);
	void gameOver();
	void editingStarted();
	void editingEnded();
	void checkEditing();
	void setHoleFocus() { game->setFocus(); }
	void inPlayStart();
	void inPlayEnd();
	void maxStrokesReached(const TQString &);
	void updateHoleMenu(int);
	void titleChanged(const TQString &);
	void newStatusText(const TQString &);
	void showInfoChanged(bool);
	void useMouseChanged(bool);
	void useAdvancedPuttingChanged(bool);
	void showGuideLineChanged(bool);
	void soundChanged(bool);
	void initPlugins();
	void showPlugins();
	void showHighScores();
	void enableAllMessages();
	void createSpacer();

	void emptySlot() {};

	void setCurrentHole(int);

private:
	TQWidget *dummy;
	KolfGame *game;
	Editor *editor;
	KolfGame *spacer;
	void initGUI();
	TQString filename;
	PlayerList players;
	PlayerList spacerPlayers;
	TQGridLayout *layout;
	ScoreBoard *scoreboard;
	KToggleAction *editingAction;
	KAction *newHoleAction;
	KAction *resetHoleAction;
	KAction *undoShotAction;
	//KAction *replayShotAction;
	KAction *clearHoleAction;
	KAction *tutorialAction;
	KAction *newAction;
	KAction *endAction;
	KAction *printAction;
	KAction *saveAction;
	KAction *saveAsAction;
	KAction *saveGameAction;
	KAction *saveGameAsAction;
	KAction *loadGameAction;
	KAction *aboutAction;
	KListAction *holeAction;
	KAction *highScoreAction;
	KAction *nextAction;
	KAction *prevAction;
	KAction *firstAction;
	KAction *lastAction;
	KAction *randAction;
	KToggleAction *showInfoAction;
	KToggleAction *useMouseAction;
	KToggleAction *useAdvancedPuttingAction;
	KToggleAction *showGuideLineAction;
	KToggleAction *soundAction;
	void setHoleMovementEnabled(bool);
	void setHoleOtherEnabled(bool);
	inline void setEditingEnabled(bool);
	bool competition;

	// contains everything
	ObjectList *obj;
	// contains subset of obj
	ObjectList plugins;

	TQString loadedGame;

	bool isTutorial;
	bool courseModified;
	TQString title;
	TQString tempStatusBarText;
};

struct HighScore
{
	HighScore() {}
	HighScore(const TQString &name, int score) { this->name = name; this->score = score; }
	TQString name;
	int score;
};
typedef TQValueList<HighScore> HighScoreList;

#endif
