#ifndef _TILE_SET_H_
#define _TILE_SET_H_


#include <tqbitmap.h>

class Tileset {
   public:
     Tileset(bool scaled=false);	     
     ~Tileset();	

     bool loadTileset(const TQString &filesetPath, const bool isPreview = false);
     QRgb *createTile(short x, short y, QRgb *dst, TQImage &src , QRgb *face);
     QRgb *copyTileImage(short tileX, short tileY, QRgb *to, TQImage &from);  

     void setScaled(bool sc) {isScaled = sc; divisor = (sc) ? 2 : 1;}


     QRgb *tile(short tnum);
     QRgb *selectedTile(short tnum);
     short width() {return w/divisor;}
     short height() {return h/divisor;}
     short shadowSize() {return ss/divisor;}
     short size() {return s;}
     short qWidth() {return qw/divisor;}
     short qHeight() {return qh/divisor;}


     TQPixmap *selectedPixmaps(int num) {
	if (!isScaled) 
		return &(selectedPix[num]);
	else
		return &(selectedMiniPix[num]);
	}

     TQPixmap *unselectedPixmaps(int num) {
	if (!isScaled)
		return &(unselectedPix[num]);
	else
		return &(unselectedMiniPix[num]);
	}

     TQPixmap *selectedShadowPixmaps(int num) {
	if (!isScaled) 
		return &(selectedShadowPix[num]);
	else
		return &(selectedShadowMiniPix[num]);
	}

     TQPixmap *unselectedShadowPixmaps(int num) {
	if (!isScaled)
		return &(unselectedShadowPix[num]);
	else
		return &(unselectedShadowMiniPix[num]);
	}

  protected:

     enum { maxTiles=45 };
  	void  createPixmap(QRgb *src, TQPixmap &dest, bool scale, bool shadow);
  

  private:
    TQBitmap maskBits;    // xbm mask for the tile
    TQBitmap maskBitsMini;    // xbm mask for the tile
    QRgb* tiles;         // Buffer containing all tiles (unselected glyphs)
    QRgb* selectedTiles; // Buffer containing all tiles (selected glyphs)


    // in version 0.5 we have moved ftom using images and calculating
    // masks etc, to using pixmaps and letting the blt do the hard work,
    // in hardware. 
    TQPixmap selectedPix[maxTiles]; // selected tiles
    TQPixmap unselectedPix[maxTiles]; // unselected tiles
    TQPixmap selectedMiniPix[maxTiles]; // selected tiles
    TQPixmap unselectedMiniPix[maxTiles]; // unselected tiles

    TQPixmap selectedShadowPix[maxTiles]; // selected tiles as above in shadow
    TQPixmap unselectedShadowPix[maxTiles]; // unselected tiles
    TQPixmap selectedShadowMiniPix[maxTiles]; // selected tiles
    TQPixmap unselectedShadowMiniPix[maxTiles]; // unselected tiles




    QRgb* selectedFace;  // The tile background face for a selected tile
    QRgb* unselectedFace;// The tile background face for an unselected tile

    QRgb  tr;    // transparenct color for tile bg

    short ss;   // left/bottom shadow width
    short bs;   // width of the border around a tile
    short w;    // tile width ( +border +shadow)
    short h;    // tile height ( +border +shadow)
    short qw;   // quarter tile width used in 3d rendering
    short qh;   // quarter tile height used in 3d rendering
    short s;	// buffer size for tile (width*height)

    TQString filename;  // cache the last file loaded to save reloading it
    bool isScaled;
    int divisor;
};


#endif


