/***************************************************************************
                             kbattleshipserver.h
                             -------------------
    Developers: (c) 2000-2001 Nikolas Zimmermann <wildfox@kde.org>
                (c) 2000-2001 Daniel Molkentin <molkentin@kde.org>

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBATTLESHIPSERVER_H
#define KBATTLESHIPSERVER_H

#include <kextsock.h>
#include <tqsocketnotifier.h>
#include <dnssd/publicservice.h>
#include "kmessage.h"

class KBattleshipServer : public KExtendedSocket
{
	Q_OBJECT
public:
	KBattleshipServer(int port, const TQString& name);
	void init();
	void sendMessage(KMessage *msg);

public slots:
	void slotDiscardClient(const TQString &reason, bool kmversion, bool bemit);

private slots:
	void slotNewConnection();
	void slotReadClient();

signals:
	void sigServerFailure();
	void sigNewConnect();
	void sigEndConnect();
	void sigNewMessage(KMessage *);
	void sigMessageSent(KMessage *);

private:
	TQSocketNotifier *m_connectNotifier;
	TQSocketNotifier *m_readNotifier;
	KExtendedSocket *m_serverSocket;
	TQString m_readBuffer;
	DNSSD::PublicService m_service;
	int m_port;
	TQString m_name;
};

#define BATTLESHIP_SERVICE "_kbattleship._tcp"

#endif
