// Copyright (c) 2002-2003 Rob Kaper <cap@capsi.com>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License version 2.1 as published by the Free Software Foundation.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this library; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.

#ifndef ATLANTIK_PORTFOLIOVIEW_H
#define ATLANTIK_PORTFOLIOVIEW_H

#include <tqwidget.h>
#include <tqpixmap.h>
#include <tqptrlist.h>

#include "portfolioestate.h"
#include "libatlantikui_export.h"
class TQColor;
class TQString;

class AtlanticCore;
class Player;
class Estate;

class LIBATLANTIKUI_EXPORT PortfolioView : public QWidget
{
Q_OBJECT

public:
	PortfolioView(AtlanticCore *core, Player *_player, TQColor activeColor, TQColor inactiveColor, TQWidget *parent, const char *name = 0);
	~PortfolioView();

	void buildPortfolio();
	void clearPortfolio();

	Player *player();

protected:
	void paintEvent(TQPaintEvent *);
	void resizeEvent(TQResizeEvent *);
	void mousePressEvent(TQMouseEvent *);

signals:
	void newTrade(Player *player);
	void kickPlayer(Player *player);
	void estateClicked(Estate *);

private slots:
	void playerChanged();
	void slotMenuAction(int item);

private:
	void loadIcon();

	AtlanticCore *m_atlanticCore;
	Player *m_player;
	PortfolioEstate *m_lastPE;
	TQColor m_activeColor, m_inactiveColor;
	TQPixmap *qpixmap, *m_image;
	TQString m_imageName;
	bool b_recreate;
	TQPtrList<PortfolioEstate> m_portfolioEstates;
};

#endif
