// Copyright (c) 2002-2004 Rob Kaper <cap@capsi.com>
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// version 2 as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.

#ifndef ATLANTIK_SELECTCONFIGURATION_WIDGET_H
#define ATLANTIK_SELECTCONFIGURATION_WIDGET_H

#include <tqwidget.h>
#include <tqlayout.h>
#include <tqvgroupbox.h>

#include <klistview.h>
#include <kpushbutton.h>

class TQCheckBox;
class TQListViewItem;

class AtlanticCore;
class ConfigOption;
class Game;
class Player;

class SelectConfiguration : public QWidget
{
Q_OBJECT

public:
	SelectConfiguration(AtlanticCore *atlanticCore, TQWidget *parent, const char *name=0);

	void setCanStart(const bool &canStart);
	TQString hostToConnect() const;
	int portToConnect();

private slots:
	void addConfigOption(ConfigOption *configOption);
	void changeOption();
	void gameOption(TQString title, TQString type, TQString value, TQString edit, TQString command);
	void optionChanged(ConfigOption *configOption);
	void optionChanged();
	void slotEndUpdate();
	void initGame();
	void playerChanged(Player *player);
	void gameChanged(Game *game);

signals:
	void startGame();
	void leaveGame();
	void joinConfiguration(int configurationId);
	void newConfiguration();
	void changeOption(int configId, const TQString &value);
	void buttonCommand(TQString);
	void iconSelected(const TQString &);
	void statusMessage(const TQString &message);

private:
	TQVBoxLayout *m_mainLayout;
	TQVGroupBox *m_configBox, *m_messageBox;
	KPushButton *m_backButton, *m_startButton;
	TQMap <TQObject *, TQString> m_optionCommandMap;
	TQMap <TQObject *, ConfigOption *> m_configMap;
	TQMap <ConfigOption *, TQCheckBox *> m_configBoxMap;
	TQMap <TQString, TQCheckBox *> m_checkBoxMap;
	TQMap <Player *, TQListViewItem *> m_items;
	Game *m_game;
	AtlanticCore *m_atlanticCore;
};

#endif
