// Copyright (c) 2002-2004 Rob Kaper <cap@capsi.com>
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// version 2 as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.

#ifndef ATLANTIK_MONOPIGATOR_H
#define ATLANTIK_MONOPIGATOR_H

#include <tqobject.h>
#include <tqbuffer.h>
#include <tqlistview.h>
#include <tqtimer.h>

#include <kio/job.h>
#include <kurl.h>

class KExtendedSocket;
class TQTime;

class Monopigator : public QObject
{
Q_OBJECT

public:
	Monopigator();
	~Monopigator();
	void loadData(const KURL &);

signals:
	void monopigatorAdd(TQString ip, TQString host, TQString port, TQString version, int users);
	void finished();
	void timeout();

private slots:
	void slotData(KIO::Job *, const TQByteArray &);
	void slotResult(KIO::Job *);
	void slotTimeout();

private:
	void processData(const TQByteArray &, bool = true);

	TQBuffer *m_downloadData;
	TQTimer *m_timer;
	KIO::Job *m_job;
};

class MonopigatorEntry : public TQObject, public QListViewItem
{
Q_OBJECT

public:
	MonopigatorEntry(TQListView *parent, TQString host, TQString latency, TQString version, TQString users, TQString port, TQString ip);
	int compare(TQListViewItem *i, int col, bool ascending) const;
	bool isDev() const;

private slots:
	void resolved();
	void connected();
	void showDevelopmentServers(bool show);

private:
	KExtendedSocket *m_latencySocket;
	TQTime time;
	TQListView *m_parent;
	bool m_isDev;
};

#endif
