#ifndef _WASKINMANAGER_H
#define _WASKINMANAGER_H

#include <dcopobject.h>
#include <tqobject.h>
#include <tqstringlist.h>
#include <tqstring.h>
#include <tqmap.h>

class WaSkinManager : public TQObject, public DCOPObject {
Q_OBJECT
K_DCOP

public:
	WaSkinManager();
	~WaSkinManager();

k_dcop:
	TQStringList availableSkins();
	TQString currentSkin();
	bool loadSkin(TQString skinName);

	TQString defaultSkin();

	bool installSkin(TQString url);

	bool skinRemovable(TQString skinName);
	bool removeSkin(TQString skinName);

	TQStringList skinMimeTypes();

signals:
	void updateSkinList();

private:
	TQString mCurrentSkin;
};

#endif
