#ifndef VOICEPRINT_H
#define VOICEPRINT_H

#include <noatun/plugin.h>

class VoicePrint : public TQWidget,  public MonoFFTScope, public Plugin
{
Q_OBJECT

public:
	VoicePrint();
	virtual ~VoicePrint();

	void setColors(const TQColor &bg, const TQColor &fg, const TQColor &l);
	void init();

protected:
	virtual void closeEvent(TQCloseEvent *);
	virtual void scopeEvent(float *data, int bands);
	virtual void resizeEvent(TQResizeEvent *);
	virtual void paintEvent(TQPaintEvent *);

public:
	static VoicePrint* voicePrint;
	
private:
	TQColor mProgress;
	TQPixmap mBuffer;
	QRgb mLowColor, mHighColor;
	int mOffset, mSegmentWidth;
};
#endif

