#ifndef USERINTERFACE_H
#define USERINTERFACE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <noatun/plugin.h>
#include <noatun/app.h>

// Pref dialog pointer global now for position saving
#include <noatun/pref.h>

class Player;
class TQSlider;
class TQPushButton;
class KStatusBar;

/**
 * @short Main window class
 * @author Charles Samuels <charles@kde.org>
 * @version 0.1
 */
class MilkChocolate : public TQWidget, public UserInterface
{
Q_OBJECT
public:
	MilkChocolate();
	virtual ~MilkChocolate();
	void load(const TQString& url);

protected:
	virtual void dragEnterEvent(TQDragEnterEvent *event);
	virtual void dropEvent(TQDropEvent *event);
	virtual void closeEvent(TQCloseEvent*);
	virtual void showEvent(TQShowEvent*e);
	virtual void mouseReleaseEvent(TQMouseEvent *);
	virtual bool eventFilter(TQObject*, TQEvent*);
	virtual void wheelEvent(TQWheelEvent *e);

protected:
	TQSlider *seeker() const { return mSeeker; }
	KStatusBar *statusBar() const { return mStatusBar; }

public slots:
	void slotPlaying();
	void slotStopped();
	void slotPaused();

	void playlistShown();
	void playlistHidden();

	void slotTimeout();
	void sliderMoved(int seconds);
	void changeLoopType(int t);
	void skipToWrapper(int second);

signals:
	void skipTo( int ); // emitted by skipToWrapper()

private slots:
	void changeStatusbar(const TQString& text, const TQString &text2=0);
	void changeCaption(const TQString& text);
	void popup();

private:
	TQPushButton *mBack, *mStop, *mPlay, *mForward, *mPlaylist, *mPopup, *mLoop;
	TQSlider *mSeeker, *mVolume;
	KStatusBar *mStatusBar;
};

#endif
