#ifndef KJLOADER_H
#define KJLOADER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// local includes
#include "parser.h"

// noatun-specific includes
#include <noatun/plugin.h>
#include <noatun/app.h>

// system includes
#include <tqwidget.h>
#include <tqbitmap.h>
#include <tqptrlist.h>
#include <tqcstring.h>

#include <kwinmodule.h>

class TQLabel;
class KJWidget;
class KHelpMenu;
class KJSeeker;
class NoatunPreferences;
class KJToolTip;
class KJFont;
class KJPrefs;


class KJLoader :  public TQWidget, public UserInterface, public Parser
{
Q_OBJECT
NOATUNPLUGIND

	friend class KJWidget;
public:
	KJLoader();
	~KJLoader();

public:
	void minimize();
	KHelpMenu *helpMenu() const { return mHelpMenu; }
	TQStringList &item(const TQString &key) { return *Parser::find(key); }

	// returns path to currently loaded configfile
	// can be either a newly loaded one or one of the three below
	TQString currentSkin() { return mCurrentSkin; }

	// returns path to mainskin-configfile
	TQString currentDefaultSkin() { return mCurrentDefaultSkin; }

	//returns path to dockmode-configfile if present
	TQString currentDockModeSkin() { return mCurrentDockModeSkin; }

	//returns path to winshademode-configfile if present (not supported yet)
	TQString currentWinshadeModeSkin() { return mCurrentWinshadeModeSkin; }

	KJPrefs *prefs() const { return mPrefs; }

	TQPtrList<KJWidget> widgetsAt(const TQPoint &pt) const;

	void removeChild(KJWidget *c);
	void addChild(KJWidget *c);

public slots:
	void loadSkin(const TQString &file);
	void readConfig();
	void switchToDockmode();
	void returnFromDockmode();

protected:
	void unloadSkin();
	void showSplash();

public slots:
	void timeUpdate();
	void newSong();

private slots:
	void loadSeeker();
	void slotWindowActivate(WId win);
	void slotWindowRemove(WId win);
	void slotWindowChange(WId win);
	void slotDesktopChange(int);
	void slotStackingChanged();
	void restack();
	void hideSplash();

protected:
	virtual void mouseMoveEvent(TQMouseEvent *e);
	virtual void mousePressEvent(TQMouseEvent *e);
	virtual void mouseReleaseEvent(TQMouseEvent *e);
	virtual void paintEvent(TQPaintEvent *e);
	virtual void closeEvent(TQCloseEvent*e);
	virtual void wheelEvent(TQWheelEvent *e);

	virtual void dragEnterEvent(TQDragEnterEvent *event);
	virtual void dropEvent(TQDropEvent *event);

public:
	static KJLoader* kjofol;

private:
	// ==== docking stuff ====
	KWinModule *mWin;
	WId mDockToWin;
	int mDockPositionX, mDockPositionY, mDockPosition;
	TQRect mDockWindowRect;
	// ==== end of docking stuff ====
	bool moving;
	TQPoint mMousePoint;
	TQPtrList<KJWidget> subwidgets;
	KJWidget *mClickedIn;
	KHelpMenu *mHelpMenu;
	KJFont *mText, *mNumbers, *mVolumeFont, *mPitchFont;
	TQLabel *splashScreen;
	KJToolTip *mTooltips;
	TQString mCurrentSkin;
	TQString mCurrentDefaultSkin;
	TQString mCurrentDockModeSkin;
	TQString mCurrentWinshadeModeSkin;

	KJPrefs *mPrefs;
};

#endif // KJLOADER_H
