#ifndef KJFONT_H
#define KJFONT_H

#include <tqstring.h>
#include <tqpixmap.h>
#include <tqbitmap.h>
#include <tqfont.h>

class KJLoader;

class KJFont
{
public:
	KJFont(const TQString &prefix, KJLoader *parent);
	// draw the string str to dev at position pos, within rectangle limit in relation to pos
	TQPixmap draw(const TQCString &str, int wide, const TQPoint &pt=TQPoint(0,0)) const;
	TQPixmap draw(const TQString &str, int wide, const TQPoint &pt=TQPoint(0,0)) const
		{ return draw(TQCString(str.latin1()), wide, pt); }

	int fontHeight() const {return mHeight;}
	int fontWidth() const {return mWidth;}
	int fontSpacing() const {return mSpacing;}
	bool isTransparent() const {return mTransparent;}

	// !!! Call if you changed the systemfont !!!
	void recalcSysFont(void);

protected:
	TQPixmap drawSysFont(const TQCString &s, int wide, const TQPoint &pos=TQPoint(0,0)) const;
	TQPixmap drawPixmapFont(const TQCString &, int, const TQPoint &pos=TQPoint(0,0)) const;

	void drawCharacter(TQPixmap *dev, TQBitmap *devMask, const TQPoint &to, char c) const;
	TQPoint charSource(char c) const;

private:
	TQPixmap mText;
	TQBitmap mTextMask;
	QRgb mTransparentRGB; // this color will be transparent
	int mSpacing;
	int mWidth, mHeight;
	bool mTransparent; // indicates wether there's transparency
	const char *mString[3];
	char mNullChar;
	TQFontMetrics *sysFontMetrics;
	TQFont sysFont;
	TQColor sysFontColor;
	bool mUseSysFont;
};

#endif
