
#ifndef _LIRC_H_
#define _LIRC_H_

#include <tqobject.h>
#include <tqstringlist.h>
#include <tqmap.h>

class TQSocket;

typedef TQMap<TQString, TQStringList> Remotes;

class Lirc : public QObject
{
Q_OBJECT
public:
	/**
	 * Constructor
	 */
	Lirc(TQObject *parent);
	/**
	 * Destructor
	 */
	virtual ~Lirc();

	/**
	 * Returns true if the connection to lircd is operational
	 */
	bool isConnected() const { return m_socket; }
	/**
	 * The names of the remote configured controls
	 */
	const TQStringList remotes() const;
	/**
	 * The names of the buttons for the specified
	 * remote control
	 */
	const TQStringList buttons(const TQString &remote) const
	{
			return m_remotes[remote];
	}

signals:
	/**
	 * Emitted when the list of controls / buttons was cmpletely read
	 */
	void remotesRead();
	/**
	 * Emitted when a IR command was received
	 * 
	 * The arguments are the name of the remote control used,
	 * the name of the button pressed and the repeat counter.
	 *
	 * The signal is emitted repeatedly as long as the button
	 * on the remote control remains pressed.
	 * The repeat counter starts with 0 and increases
	 * every time this signal is emitted.
	 */
	void commandReceived(const TQString &, const TQString &, int);
	
private slots:
	void slotRead();
	
private:
	void update();
	const TQString readLine();
	void sendCommand(const TQString &);
	
private:
	TQSocket *m_socket;
	Remotes m_remotes;
};

#endif

