
#ifndef _IRPREFS_H_
#define _IRPREFS_H_

#include <tqmap.h>
#include <noatun/pref.h>

class TQCheckBox;
class TQListViewItem;
class KListView;
class KComboBox;
class KIntSpinBox;
class Lirc;

class IRPrefs : public CModule
{
Q_OBJECT
public:
	enum Action
	{
		None, Play, Stop, Pause, Mute,
		Previous, Next, VolumeDown, VolumeUp,
		SeekBackward, SeekForward, ShowPlaylist,
		NextSection, PreviousSection
	};
	
	IRPrefs(TQObject *parent);
	
	virtual void save();

	static const TQString actionName(Action);
	static Action actionFor(const TQString &, const TQString &, int);
	
public slots:
	static Lirc *s_lirc;

private slots:
	virtual void reopen();
	void slotCommandSelected(TQListViewItem *);
	void slotActionActivated(int);
	void slotRepeatToggled(bool);
	void slotIntervalChanged(int);

private:
	static void readConfig();

	KListView *m_commands;
	KComboBox *m_action;
	TQCheckBox *m_repeat;
	KIntSpinBox *m_interval;

	struct Command
	{
		Action action;
		int interval;
	};
	static bool s_configRead;
	static TQMap<TQString, Command> s_commands;
};

#endif

