/****************************************************************************
	Copyright (C) 2002 Charles Samuels
	this file is on the BSD license, sans advertisement clause
 *****************************************************************************/

#include <noatun/video.h>
#include <noatun/app.h>
#include <noatun/player.h>
#include <noatun/engine.h>

#include <tqpopupmenu.h>
#include <kaction.h>
#include <klocale.h>

#include "globalvideo.h"

// sorry :)
TQPtrList<VideoFrame> VideoFrame::frames;

VideoFrame *VideoFrame::whose=0;

struct VideoFrame::Private
{
};


VideoFrame::VideoFrame(KXMLGUIClient *clientParent, TQWidget *parent, const char*name, WFlags f)
	: KVideoWidget(clientParent, parent, name, f)
{
	d = new Private;
	connect(napp->player(), TQT_SIGNAL(newSong()), TQT_SLOT(changed()));
	connect(napp->player(), TQT_SIGNAL(stopped()), TQT_SLOT(stopped()));
	frames.append(this);
}

VideoFrame::VideoFrame(TQWidget *parent, const char *name, WFlags f)
	 : KVideoWidget(parent, name, f)
{
	d = new Private;
	connect(napp->player(), TQT_SIGNAL(newSong()), TQT_SLOT(changed()));
	connect(napp->player(), TQT_SIGNAL(stopped()), TQT_SLOT(stopped()));
	frames.append(this);
}

VideoFrame::~VideoFrame()
{
	if (whose == this)
	{
		embed(Arts::VideoPlayObject::null());
		whose=0;
	}

	frames.removeRef(this);
	VideoFrame *l = frames.last();
	if (l) l->give();
	else whose=0;
	delete d;
}

VideoFrame *VideoFrame::playing()
{
	return whose;
}

TQPopupMenu *VideoFrame::popupMenu(TQWidget *parent)
{
    TQPopupMenu *view = new TQPopupMenu(parent);
    action( "half_size" )->plug( view );
    action( "normal_size" )->plug( view );
    action( "double_size" )->plug( view );
    view->insertSeparator();
    action( "fullscreen_mode" )->plug( view );
	return view;
}

void VideoFrame::give()
{
	VideoFrame *old=whose;
	whose = this;
	
	if (whose != old && old != 0)
	{
		old->embed(Arts::VideoPlayObject::null());
		emit old->lost();
	}

	Arts::PlayObject po = napp->player()->engine()->playObject();
	if (po.isNull()) return;
	
	Arts::VideoPlayObject vpo = Arts::DynamicCast(po);
	if (!vpo.isNull())
	{
		embed(vpo);
		emit acquired();
	}
}

void VideoFrame::changed()
{
	if (whose==this)
		give();
}

void VideoFrame::stopped()
{
	if (whose==this)
	{
		embed(Arts::VideoPlayObject::null());
		emit lost();
	}
}

#include <tqlayout.h>


GlobalVideo::GlobalVideo()
    : TQWidget( 0, 0, WType_TopLevel | WStyle_Customize | WStyle_DialogBorder | WStyle_Title )
{
	setCaption(i18n("Video - Noatun"));
	(new TQVBoxLayout(this))->setAutoAdd(true);
	video = new VideoFrame(this);
	menu = video->popupMenu(this);

	// FIXME: How to obtain minimum size for top-level widgets?
//	video->setMinimumSize(minimumSizeHint());
//	video->setMinimumSize(101,35);
	video->setMinimumSize(128,96);

	connect(video, TQT_SIGNAL(acquired()), TQT_SLOT(appear()));
	connect(video, TQT_SIGNAL(lost()), TQT_SLOT(hide()));
	connect(video, TQT_SIGNAL(adaptSize(int,int)), this, TQT_SLOT(slotAdaptSize(int,int)));

	video->setNormalSize();
	video->give();
}

void GlobalVideo::slotAdaptSize(int w, int h)
{
    resize(w, h);
}

void GlobalVideo::appear()
{
	TQWidget::show();
}

void GlobalVideo::hide()
{
	TQWidget::hide();
}

void GlobalVideo::mouseReleaseEvent(TQMouseEvent *e)
{
	if (e->button() == RightButton)
	{
		menu->exec(mapToGlobal(e->pos()));
	}
}

#include "globalvideo.moc"
#include "video.moc"

