#include "equalizer.h"
#include "engine.h"
#include <common.h>
#include <dynamicrequest.h>
#include <artsflow.h>
#include <app.h>
#include <player.h>
#include <soundserver.h>
#include <noatunarts.h>
#include <ktempfile.h>
#include <tqdom.h>
#include <kio/netaccess.h>
#include <kstandarddirs.h>
#include <tqtextstream.h>
#include <math.h>
#include <kconfig.h>
#include <klocale.h>
#include "ksaver.h"

#define EQ napp->equalizer()
#define VEQ napp->vequalizer()

struct OldEqCruft
{
	VInterpolation *interpolated;

};

static OldEqCruft *eqCruft=0;

Preset::Preset(const TQString &)
{ } // unused

Preset::Preset(VPreset p)
{
	VPreset *copy = new VPreset(p);
	
	// isn't this horrible? :)
	mFile = TQString::number((unsigned long)copy);
}

Preset::Preset()
{ } // unused

VPreset &Preset::vpreset() const
{
	unsigned long addr = mFile.toULong();
	return *(VPreset*)addr;
}

TQString Preset::name() const
{
	return vpreset().name();
}

bool Preset::setName(const TQString &name)
{
	return vpreset().setName(name);
}

bool Preset::save() const
{
	vpreset().save();
	return true;
}

bool Preset::load()
{
	vpreset().load();
	return true;
}

void Preset::remove()
{
	vpreset().remove();
}

TQString Preset::file() const
{
	return vpreset().file();
}


Band::Band(int, int)
{
	// Never used
}

Band::Band(int num)
	: mNum(num)
{

}

Band::~Band()
{}

int Band::level()
{
	return eqCruft->interpolated->band(mNum).level();
}

void Band::setLevel(int l)
{
	eqCruft->interpolated->band(mNum).setLevel(l);
}

int Band::start() const
{
	return eqCruft->interpolated->band(mNum).start();
}

int Band::end() const
{
	return eqCruft->interpolated->band(mNum).end();
}

int Band::center() const
{
	return eqCruft->interpolated->band(mNum).center();
}

TQString Band::formatStart(bool withHz) const
{
	return eqCruft->interpolated->band(mNum).formatStart(withHz);
}

TQString Band::formatEnd(bool withHz) const
{
	return eqCruft->interpolated->band(mNum).formatEnd(withHz);
}

TQString Band::format(bool withHz) const
{
	return eqCruft->interpolated->band(mNum).format(withHz);
}


Equalizer::Equalizer() 
{
}

Equalizer::~Equalizer()
{
	delete eqCruft->interpolated;
	delete eqCruft;

//	save(napp->dirs()->saveLocation("data", "noatun/") + "equalizer", "auto");
	for (Band *i=mBands.first(); i!=0; i=mBands.next())
		delete i;
}


void Equalizer::init()
{
	// must be called after VEqualizer::init 
	eqCruft = new OldEqCruft;
	eqCruft->interpolated = new VInterpolation(6);
	
	mBands.append(new Band(0));
	mBands.append(new Band(1));
	mBands.append(new Band(2));
	mBands.append(new Band(3));
	mBands.append(new Band(4));
	mBands.append(new Band(5));
	
	connect(VEQ, TQT_SIGNAL(changed()), TQT_SIGNAL(changed()));
	
	connect(VEQ, TQT_SIGNAL(created(VPreset)), TQT_SLOT(created(VPreset)));
	connect(VEQ, TQT_SIGNAL(selected(VPreset)), TQT_SLOT(selected(VPreset)));
	connect(VEQ, TQT_SIGNAL(renamed(VPreset)), TQT_SLOT(renamed(VPreset)));
	connect(VEQ, TQT_SIGNAL(removed(VPreset)), TQT_SLOT(removed(VPreset)));
	
	connect(VEQ, TQT_SIGNAL(enabled()), TQT_SIGNAL(enabled()));
	connect(VEQ, TQT_SIGNAL(disabled()), TQT_SIGNAL(disabled()));
	connect(VEQ, TQT_SIGNAL(enabled(bool)), TQT_SIGNAL(enabled(bool)));
	
	connect(VEQ, TQT_SIGNAL(preampChanged(int)), TQT_SIGNAL(preampChanged(int)));
	connect(VEQ, TQT_SIGNAL(preampChanged(int)), TQT_SIGNAL(preampChanged(int)));
}

void Equalizer::created(VPreset preset)
{
	Preset *p = new Preset(preset);
	emit created(p);
	delete p;
}

void Equalizer::selected(VPreset preset)
{
	Preset *p = new Preset(preset);
	emit changed(p);
	delete p;
}

void Equalizer::renamed(VPreset preset)
{
	Preset *p = new Preset(preset);
	emit renamed(p);
	delete p;
}

void Equalizer::removed(VPreset preset)
{
	Preset *p = new Preset(preset);
	emit removed(p);
	delete p;
}

TQPtrList<Preset> Equalizer::presets() const
{
	TQValueList<VPreset> presets = VEQ->presets();
	TQPtrList<Preset> list;
	for (
			TQValueList<VPreset>::Iterator i(presets.begin());
			i != presets.end(); ++i
		)
	{
		list.append(new Preset(*i));
	}
	return list;
}

Preset *Equalizer::preset(const TQString &file)
{
	VPreset p = VEQ->presetByFile(file);
	if (!p) return 0;
	return new Preset(p);
}

bool Equalizer::presetExists(const TQString &name) const
{
	return VEQ->presetExists(name);
}

Preset *Equalizer::createPreset(const TQString &name, bool smart)
{
	VPreset p = VEQ->createPreset(name, smart);
	if (!p) return 0;
	return new Preset(p);
}

const TQPtrList<Band> &Equalizer::bands() const
{
	return mBands;
}

Band *Equalizer::band(int num) const
{
	// can't use TQPtrList::at since it sets current

	TQPtrListIterator<Band> item(mBands);
	item+=(unsigned int)num;
	return *item;
}

int Equalizer::bandCount() const
{
	return 6; // hmm ;)
}

int Equalizer::preamp() const
{
	return VEQ->preamp();
}

bool Equalizer::isEnabled() const
{
	return VEQ->isEnabled();

}

void Equalizer::setPreamp(int p)
{
	VEQ->setPreamp(p);
}

void Equalizer::enable()
{
	setEnabled(true);
}

void Equalizer::disable()
{
	setEnabled(false);
}

void Equalizer::setEnabled(bool e)
{
	VEQ->setEnabled(e);
}

TQString Equalizer::toString(const TQString &name) const
{
	return VEQ->toString(name);
}

bool Equalizer::fromString(const TQString &str)
{
	return VEQ->fromString(str);
}

bool Equalizer::save(const KURL &filename, const TQString &name) const
{
	return VEQ->save(filename, name);
}



bool Equalizer::load(const KURL &filename)
{
	return VEQ->load(filename);
}

void Equalizer::add(Band *)
{
	// should never be called
}

void Equalizer::remove(Band *)
{
	// should never be called
}

void Equalizer::update(bool)
{
	// should never be called
}

void Equalizer::enableUpdates(bool)
{
	// should never be called
}

#undef EQ
#undef EQBACK

#include "equalizer.moc"

