/***************************************************************************
    copyright            : (C) 2003 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef KREC_NEW_PROPERTIES_H
#define KREC_NEW_PROPERTIES_H

#include <tqdialog.h>

class KConfig;
class TQBoxLayout;
class TQButtonGroup;
class TQRadioButton;
class KPushButton;
class TQHBox;
class TQVBox;

class KRecConfigFilesWidget;

class KRecNewProperties : public TQDialog {
   Q_OBJECT
public:
	KRecNewProperties( TQWidget*, const char* =0 );
	~KRecNewProperties();

	TQString filename();
	int samplerate();
	int channels();
	int bits();
	bool usedefaults();

	void done( int );
private slots:
	void ratechanged( int );
	void channelschanged( int );
	void bitschanged( int );
	void usedefaultschanged( bool );
private:
	TQString _filename;
	KRecConfigFilesWidget *_filewidget;

	int _samplerate, _channels, _bits;
	bool _usedefaults;

	TQBoxLayout *_layout, *_layoutbuttons;
	KPushButton *_btnok;
};

#endif

// vim:sw=4:ts=4
