/***************************************************************************
    copyright            : (C) 2003 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef KREC_GLOBAL_H
#define KREC_GLOBAL_H

#include <tqobject.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqdict.h>

class KConfig;
class TQWidget;
class KStatusBar;

class KRecExportItem;

class KRecGlobal : public TQObject {
   Q_OBJECT
private:
	KRecGlobal( TQObject* =0, const char* =0 );
	~KRecGlobal();

public:

	/**
	 * @return Returns a pointer to the global KRecGlobal.
	 */
	static KRecGlobal* the();

	/**
	 * Sets the MainWidget.
	 */
	void setMainWidget( TQWidget* );
	/**
	 * Returns a pointer to the mainwidget.
	 * Usefull to display Messageboxes, etc correctly without beeing a
	 * TQWidget or knowing about a parent TQWidget.
	 */
	TQWidget* mainWidget();

	/// @return kapp->config()
	static KConfig* kconfig();

	/// Sets the Statusbar.
	void setStatusBar( KStatusBar* );
	/**
	 * Puts a message into the statusbar.
	 * Usefull for showing messages without knowing about the Statusbar.
	 */
	void message( const TQString & );

	/// Registers a KRecExportItem
	static bool registerExport( KRecExportItem* );
	/**
	 * Returns a new KRecExportItem for the specified exportFormat.
	 * If now Item can be found the return value is 0.
	 */
	KRecExportItem* getExportItem( const TQString &exportFormat );
	///
	KRecExportItem* getExportItemForEnding( const TQString & );
	/// Returns a list of exportFormats.
	TQStringList exportFormats() const;
	/// Returns a list of fileendings.
	TQString exportFormatEndings() const;

	/**
	 * Gets/Sets the actual mode for formating time values.
	 *
	 * For description see krecfileview.h
	*/
	int timeFormatMode();
	void setTimeFormatMode( int );
	/// The framebase (how many frames per second) (25/30 for movies, 75 for CDs)
	int frameBase();
	void setFrameBase( int );
private:
	TQWidget *_qwidget;
	KStatusBar *_statusbar;
	TQDict <KRecExportItem> *_exports;
	TQStringList _exportformats;
	int _timeformatcache, _framebasecache;
};

#endif

// vim:sw=4:ts=4
