#ifndef ViewSwitches_h
#define ViewSwitches_h

class TQLayout;
class TQWidget;

class Mixer;
#include "viewbase.h"

class ViewSwitches : public ViewBase
{
    Q_OBJECT
public:
    ViewSwitches(TQWidget* parent, const char* name, const TQString & caption, Mixer* mixer, ViewBase::ViewFlags vflags);
    ~ViewSwitches();

    virtual int count();
    virtual int advice();
    virtual void setMixSet(MixSet *mixset);
    virtual TQWidget* add(MixDevice *mdw);
    virtual void constructionFinished();
    virtual void configurationUpdate();

    TQSize sizeHint() const;

public slots:
    virtual void refreshVolumeLevels();

private:
    TQLayout* _layoutMDW;
    TQLayout* _layoutEnum;
    TQLayout* _layoutSwitch;
};

#endif

