/*
 * KMix -- KDE's full featured mini mixer
 *
 *
 * Copyright (C) 2000 Stefan Schimanski <1Stein@gmx.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KPREFDLG_H
#define KPREFDLG_H

#include <kdialogbase.h>

class KMixPrefWidget;
class KMixApp;
class TQCheckBox;
class TQRadioButton;

class 
KMixPrefDlg : public KDialogBase  
{
   Q_OBJECT

   friend class KMixWindow;

  public: 
   KMixPrefDlg( TQWidget *parent );
   ~KMixPrefDlg();

  signals:
   void signalApplied( KMixPrefDlg *prefDlg );

   private slots:
      void apply();

  private:
   TQFrame *m_generalTab;
   KMixApp *m_mixApp;
   KMixPrefWidget *m_mixPrefTab;

   TQCheckBox *m_autoStartChk;
   TQCheckBox *m_dockingChk;
   TQCheckBox *m_volumeChk;
   TQCheckBox *m_hideOnCloseChk;
   TQCheckBox *m_showTicks;
   TQCheckBox *m_showLabels;
   TQCheckBox *m_onLogin;
   TQCheckBox *m_dockIconMuting;
   TQRadioButton *_rbVertical;
   TQRadioButton *_rbHorizontal;
   TQRadioButton *_rbNone;
   TQRadioButton *_rbAbsolute;
   TQRadioButton *_rbRelative;
};

#endif
