/*
 * KMix -- KDE's full featured mini mixer
 *
 *
 * Copyright (C) 2000 Stefan Schimanski <1Stein@gmx.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KLEDBUTTON_H
#define KLEDBUTTON_H

#include <tqwidget.h>

#include <kled.h>

/**
  *@author Stefan Schimanski
  */

class KLedButton : public KLed  {
   Q_OBJECT
  public: 
   KLedButton(const TQColor &col=Qt::green, TQWidget *parent=0, const char *name=0);
   KLedButton(const TQColor& col, KLed::State st, KLed::Look look, KLed::Shape shape,
	      TQWidget *parent=0, const char *name=0);
   ~KLedButton();	

   TQSize sizeHint () const;
   TQSizePolicy sizePolicy () const;
  signals:
   void stateChanged( bool newState );

  protected:	
   void mousePressEvent ( TQMouseEvent *e );

 private:
   bool eventFilter( TQObject*, TQEvent* );
};

#endif
