/*****************************************************************

Copyright (c) 2000-2001 the noatun authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIAB\ILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __CONTROLS_H
#define __CONTROLS_H

#include <tqguardedptr.h>

#include <kaction.h>
#include <ktoolbar.h>
#include <tqslider.h>
#include <tqstringlist.h>

class TQComboBox;
class TQLabel;

namespace Kaboodle
{
/**
 * A slider that can be moved around while being
 * changed internally
 **/
class L33tSlider : public QSlider
{
Q_OBJECT
public:
	L33tSlider(TQWidget * parent, const char * name=0);
	L33tSlider(Orientation, TQWidget * parent, const char * name=0);
	L33tSlider(int minValue, int maxValue, int pageStep, int value,
	           Orientation, TQWidget * parent, const char * name=0);

	bool currentlyPressed() const;
signals:
	/**
	 * emmited only when the user changes the value by hand
	 **/
	void userChanged(int value);

public slots:
	virtual void setValue(int);
protected:
	virtual void mousePressEvent(TQMouseEvent*);
	virtual void mouseReleaseEvent(TQMouseEvent*);
	virtual void wheelEvent(TQWheelEvent *e);

private:
	bool pressed;
};

/**
 * A slider for your toolbar
 **/
class SliderAction : public KAction
{
Q_OBJECT
public:
	SliderAction(const TQString& text, int accel, const TQObject *receiver,
	             const char *member, TQObject* parent, const char* name );
	virtual int plug( TQWidget *w, int index = -1 );
	virtual void unplug( TQWidget *w );
	TQSlider* slider() const { return m_slider; }

signals:
	void plugged();

public slots:
	void toolbarMoved(KToolBar::BarPosition pos);
private:
	TQGuardedPtr<TQSlider> m_slider;
	TQStringList m_items;
	const TQObject *m_receiver;
	const char *m_member;
};

}

#endif
