/*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de
                  2003 Arnold Krille
                       arnold@arnoldarts.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    */

#ifndef _AUDIOMANAGER_H_
#define _AUDIOMANAGER_H_

#include <artsflow.h>
#include <tqwidget.h>
#include <tqlistview.h>

#include "templateview.h"

class KListView;
class GuiAudioManagerProxy;
class TQBoxLayout;

class Gui_AUDIO_MANAGER : public Template_ArtsView
{
	Q_OBJECT
protected:
	TQWidget *ParentWidget;
	KListView *listview;
	GuiAudioManagerProxy *proxy;
	Arts::AudioManager AudioManager;

	bool inDialog;
	unsigned long changes;
	int x,y;
public:
	Gui_AUDIO_MANAGER( TQWidget* =0, const char* =0 );
	~Gui_AUDIO_MANAGER();

	void setParent(TQWidget *Parent,TQBoxLayout *layout);

	void edit(TQListViewItem *item);
public slots:
	void tick();
};

class GuiAudioManagerProxy :public TQObject {
	Q_OBJECT
	Gui_AUDIO_MANAGER *gim;
public:
	GuiAudioManagerProxy(Gui_AUDIO_MANAGER *gim);
public slots:
	void edit(TQListViewItem *item);
};

class AudioManagerItem : public TQListViewItem {
	long _ID;
public:
	AudioManagerItem(TQListView *parent, TQString a, TQString b,
			              TQString c, long ID);
	~AudioManagerItem();

	long ID();
};

#endif
