/***************************************************************************
                          kpoti.h  -  Potentiometer Widget
                             -------------------
    begin                : Wed Apr 28 23:05:05 MEST 1999

    copyright            : (C) 1999 by Martin Lorenz
    email                : lorenz@ch.tum.de
                           (C) 2002 Matthias Kretz <kretz@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _KPOTI_H
#define _KPOTI_H

#include <tqframe.h>
#include <tqrangecontrol.h>


class TQTimer;
struct QPotiData;


class KPoti : public TQFrame, public QRangeControl
{
    Q_OBJECT
public:

    KPoti( TQWidget *parent=0, const char *name=0 );
    KPoti( int minValue, int maxValue, int step, int value,
	     TQWidget *parent=0, const char *name=0 );

    ~KPoti();

    void	setTracking( bool enable );
    bool	tracking() const;

    void 	setColor( const TQColor & );

    virtual void setTickmarks( bool );
    virtual void setLabel( bool );
    bool        tickmarks() const { return ticks; }

    virtual void setTickInterval( int );
    int 	tickInterval() const { return tickInt; }

    virtual TQSizePolicy sizePolicy() const;
    virtual TQSize sizeHint() const;
    virtual TQSize minimumSizeHint() const;
    TQString text() const;

public slots:
    void	setValue( int );
    void	addStep();
    void	subtractStep();
    void	setText( const TQString & );

signals:
    void	valueChanged( int value );
    void	potiPressed();
    void	potiMoved( int value );
    void	potiReleased();
    void  mouseEntered(int value);

protected:
    void	resizeEvent( TQResizeEvent * );
    void	drawContents( TQPainter * );

    void	keyPressEvent( TQKeyEvent * );

    void	mousePressEvent( TQMouseEvent * );
    void	mouseReleaseEvent( TQMouseEvent * );
    void	mouseMoveEvent( TQMouseEvent * );
    void  enterEvent( TQEvent *);

    void	focusInEvent( TQFocusEvent *e );
    void	focusOutEvent( TQFocusEvent *e );

    void	valueChange();
    void	rangeChange();

    virtual void paletteChange( const TQPalette & );

    virtual void paintPoti( TQPainter * );
    void	drawButton( TQPainter *);
    void	drawTicks( TQPainter *, double, double, int=1 ) const;

    virtual void wheelEvent(TQWheelEvent *e);
private slots:
    void	repeatTimeout();

private:
    enum State { Idle, Dragging, TimingUp, TimingDown };

    void	init(int value=0);
    float      	positionFromValue( int ) const;
    int		valueFromPosition( float ) const;
    void	movePoti( float );
    void	reallyMovePoti( float );
    void	resetState();
    int		potiRadius() const;
    void	initTicks();

    QTimer	*timer;
    float	potiPos;
    int		potiVal;
    int 	clickOffset;
    State	state;
    bool	track;
    bool	ticks, m_bLabel;
    int		tickInt, space;
    double buttonRadius;
private:	// Disabled copy constructor and operator=
    //    KPoti( const KPoti & ) {}
    //KPoti &operator=( const KPoti & ) { return *this; }
    struct KPotiPrivate;
    KPotiPrivate * d;
};

inline bool KPoti::tracking() const
{
    return track;
}


#endif // _KPOTI_H



