    /*

    Copyright (C) 2001 Stefan Westerfeld
                       stefan@space.twc.de
                  2003 Arnold Krille <arnold@arnoldarts.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
  
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
   
    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

    */

#include "kartswidget.h"
#include "kwidgetrepo.h"
#include "debug.h"
#include "tqlayout.h"

class KArtsWidgetPrivate {
public:
	TQHBoxLayout *layout;
};

KArtsWidget::KArtsWidget( TQWidget* parent, const char* name )
	:TQWidget( parent, name ), _content( Arts::Widget::null() )
{
	d = new KArtsWidgetPrivate;
	d->layout = new TQHBoxLayout(this);
}

KArtsWidget::KArtsWidget( Arts::Widget content, TQWidget* parent, const char* name )
	:TQWidget( parent, name ), _content( Arts::Widget::null())
{
	d = new KArtsWidgetPrivate;
	d->layout = new TQHBoxLayout(this);
	setContent(content);
}

KArtsWidget::KArtsWidget( Arts::Widget content, TQWidget* parent, const char* name, WFlags wflags )
	:TQWidget( parent, name, wflags ), _content( Arts::Widget::null() )
{
	d = new KArtsWidgetPrivate;
	d->layout = new TQHBoxLayout( this );
	setContent( content );
}

KArtsWidget::KArtsWidget(TQWidget* parent, const char* name, WFlags wflags )
	:TQWidget(parent, name, wflags ), _content(Arts::Widget::null())
{
	d = new KArtsWidgetPrivate;
	d->layout = new TQHBoxLayout(this);
}

KArtsWidget::~KArtsWidget()
{
	TQWidget *contentAsWidget
		= KWidgetRepo::the()->lookupQWidget(_content.widgetID());
	contentAsWidget->reparent(0,TQPoint(0,0),_content.visible());
	delete d;
	d = 0;
}

/* TODO: change content (reparent old widget away, reparent new widget here) */
void KArtsWidget::setContent(Arts::Widget content)
{
	arts_return_if_fail(!content.isNull());
	TQWidget *contentAsWidget
		= KWidgetRepo::the()->lookupQWidget(content.widgetID());
	arts_return_if_fail(contentAsWidget != 0);

	_content = content;
	contentAsWidget->reparent(this,TQPoint(0,0),content.visible());
	d->layout->addWidget(contentAsWidget);
}

Arts::Widget KArtsWidget::content()
{
	return _content;
}
