#ifndef __MENUMAKER_H__
#define __MENUMAKER_H__

#include <kaction.h>
#include <tqobject.h>
#include <string>
#include <list>

class MenuMaker;

class MenuEntry : public QObject
{
	Q_OBJECT

protected:
	MenuMaker *menumaker;
	KAction *action;
	TQCString text;

public:
	MenuEntry(MenuMaker *menumaker, KActionMenu *parent, const char *text);

public slots:
	void activated();
};

class MenuCategory
{
protected:
	KActionMenu *_menu;
	TQString _name;
	std::list<std::string> prefixList;
	bool _catchall;

public:
	MenuCategory(const TQString& name, const char *prefix, KActionMenu *menu);

	void addPrefix(const char *prefix);
	TQString name();
	KActionMenu *menu();

	bool catchall();
	bool matches(const char *item);
};

class MenuMaker :public QObject
{
	Q_OBJECT

	std::list<MenuCategory *> categories;
public:
	enum { CAT_MAGIC_ID = 10000 };

	MenuMaker(KActionMenu *root);

	void addCategory(const TQString& name, const char *prefix);
	MenuCategory *lookupCategoryByName(const TQString& name);
	void addItem(const char *name, int i);
	TQString basename(const TQString& name);
	TQString catname(const TQString& name);

	void clear();

	const char *findID(int id);

	void menuActivated(const char *text);
signals:
	void activated(const char *text);
};
#endif
