/*

chooser widget for KDM

Copyright (C) 2002-2003 Oswald Buddenhagen <ossi@kde.org>
based on the chooser (C) 1999 by Harald Hoyer <Harald.Hoyer@RedHat.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include <config.h>

#ifdef XDMCP

#include "kchooser.h"
#include "kconsole.h"
#include "kdmconfig.h"
#include "kdm_greet.h"

#include <klocale.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqpopupmenu.h>
#include <tqsocketnotifier.h>
#include <tqlistview.h>
#include <tqlineedit.h>

#include <stdlib.h> // for free()

class ChooserListViewItem : public TQListViewItem {
  public:
	ChooserListViewItem( TQListView* parent, int _id, const TQString& nam, const TQString& sts )
		: TQListViewItem( parent, nam, sts ) { id = _id; };

	int id;
};


ChooserDlg::ChooserDlg()
	: inherited()
{
	completeMenu( LOGIN_REMOTE_ONLY, ex_greet, i18n("&Local Login"), ALT+Key_L );

	TQBoxLayout *vbox = new TQVBoxLayout( this, 10, 10 );

	TQLabel *title = new TQLabel( i18n("XDMCP Host Menu"), this );
	title->setAlignment( AlignCenter );
	vbox->addWidget( title );

	host_view = new TQListView( this, "hosts" );
	host_view->addColumn( i18n("Hostname") );
	host_view->setColumnWidth( 0, fontMetrics().width( "login.crap.net" ) );
	host_view->addColumn( i18n("Status") );
	host_view->setMinimumWidth( fontMetrics().width( "login.crap.com Display not authorized to connect this server" ) );
	host_view->setResizeMode( TQListView::LastColumn );
	host_view->setAllColumnsShowFocus( true );
	vbox->addWidget( host_view );

	iline = new TQLineEdit( this );
	iline->setEnabled( TRUE );
	TQLabel *itxt = new TQLabel( iline, i18n("Hos&t:"), this );
	TQPushButton *addButton = new TQPushButton( i18n("A&dd"), this );
	connect( addButton, TQT_SIGNAL(clicked()), TQT_SLOT(addHostname()) );
	TQBoxLayout *hibox = new TQHBoxLayout( vbox, 10 );
	hibox->addWidget( itxt );
	hibox->addWidget( iline );
	hibox->addWidget( addButton );

	// Buttons
	TQPushButton *acceptButton = new TQPushButton( i18n("&Accept"), this );
	acceptButton->setDefault( true );
	TQPushButton *pingButton = new TQPushButton( i18n("&Refresh"), this );

	TQBoxLayout *hbox = new TQHBoxLayout( vbox, 20 );
	hbox->addWidget( acceptButton );
	hbox->addWidget( pingButton );
	hbox->addStretch( 1 );

	if (optMenu) {
		TQPushButton *menuButton = new TQPushButton( i18n("&Menu"), this );
		menuButton->setPopup( optMenu );
		hbox->addWidget( menuButton );
		hbox->addStretch( 1 );
	}

//	TQPushButton *helpButton = new TQPushButton( i18n("&Help"), this );
//	hbox->addWidget( helpButton );

#ifdef WITH_KDM_XCONSOLE
	if (consoleView)
		vbox->addWidget( consoleView );
#endif

	sn = new TQSocketNotifier( rfd, TQSocketNotifier::Read, this );
	connect( sn, TQT_SIGNAL(activated( int )), TQT_SLOT(slotReadPipe()) );

	connect( pingButton, TQT_SIGNAL(clicked()), TQT_SLOT(pingHosts()) );
	connect( acceptButton, TQT_SIGNAL(clicked()), TQT_SLOT(accept()) );
//	connect( helpButton, TQT_SIGNAL(clicked()), TQT_SLOT(slotHelp()) );
	connect( host_view, TQT_SIGNAL(doubleClicked(TQListViewItem *)), TQT_SLOT(accept()) );

	adjustGeometry();
}

/*
void ChooserDlg::slotHelp()
{
	KMessageBox::information(0,
	                         i18n("Choose a host, you want to work on,\n"
	                              "in the list or add one.\n\n"
	                              "After this box, you must press cancel\n"
	                              "in the Host Menu to enter a host. :("));
	iline->setFocus();
}
*/

void ChooserDlg::addHostname()
{
	if (!iline->text().isEmpty()) {
		GSendInt( G_Ch_RegisterHost );
		GSendStr( iline->text().latin1() );
		iline->clear();
	}
}

void ChooserDlg::pingHosts()
{
	GSendInt( G_Ch_Refresh );
}

void ChooserDlg::accept()
{
	if (focusWidget() == iline) {
		if (!iline->text().isEmpty()) {
			GSendInt( G_Ch_DirectChoice );
			GSendStr( iline->text().latin1() );
			iline->clear();
		}
		return;
	} else /*if (focusWidget() == host_view)*/ {
		TQListViewItem *item = host_view->currentItem();
		if (item) {
			GSendInt( G_Ready );
			GSendInt( ((ChooserListViewItem *)item)->id );
			::exit( EX_NORMAL );
		}
	}
}

void ChooserDlg::reject()
{
}

TQString ChooserDlg::recvStr()
{
	char *arr = GRecvStr();
	if (arr) {
		TQString str = TQString::fromLatin1( arr );
		free( arr );
		return str;
	} else
		return i18n("<unknown>");
}

TQListViewItem *ChooserDlg::findItem( int id )
{
	TQListViewItem *itm;
	for (TQListViewItemIterator it( host_view ); (itm = it.current()); ++it)
		if (((ChooserListViewItem *)itm)->id == id)
			return itm;
	return 0;
}

void ChooserDlg::slotReadPipe()
{
	int id;
	TQString nam, sts;

	int cmd = GRecvInt();
	switch (cmd) {
	case G_Ch_AddHost:
	case G_Ch_ChangeHost:
		id = GRecvInt();
		nam = recvStr();
		sts = recvStr();
		GRecvInt(); /* swallow willing for now */
		if (cmd == G_Ch_AddHost)
			host_view->insertItem(
				new ChooserListViewItem( host_view, id, nam, sts ) );
		else {
			TQListViewItem *itm = findItem( id );
			itm->setText( 0, nam );
			itm->setText( 1, sts );
		}
		break;
	case G_Ch_RemoveHost:
		delete findItem( GRecvInt() );
		break;
	case G_Ch_BadHost:
		KFMsgBox::box( this, TQMessageBox::Warning, i18n("Unknown host %1").arg( recvStr() ) );
		break;
	case G_Ch_Exit:
		done( ex_exit );
		break;
	default: /* XXX huuh ...? */
		break;
	}
}

#include "kchooser.moc"

#endif
