/*
  Copyright (c) 2000 Matthias Elter <elter@kde.org>
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 
*/                                                                            

#ifndef __indexwidget_h__
#define __indexwidget_h__

#include <tqwidgetstack.h>

#include "global.h"

class ConfigModuleList;
class ConfigModule;
class ModuleTreeView;
class ModuleIconView;

class IndexWidget : public QWidgetStack
{
  Q_OBJECT
  
public:   
  IndexWidget(ConfigModuleList *list, TQWidget *parent, const char *name=0);
  virtual ~IndexWidget();

  TQListViewItem *firstTreeViewItem();
public slots:
  void makeVisible(ConfigModule *module);
  void makeSelected(ConfigModule *module);
  void activateView(IndexViewMode);
  void reload();

protected slots:
  void moduleSelected(ConfigModule *);

signals:
  void moduleActivated(ConfigModule *module);
  void categorySelected(TQListViewItem *);

protected:
  void resizeEvent(TQResizeEvent *e);

private:
  ModuleTreeView   *_tree;
  ModuleIconView   *_icon;
  ConfigModuleList *_modules;
  IndexViewMode    viewMode;
};

#endif
