/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef UPCVALIDATOR_H
#define UPCVALIDATOR_H

#include <tqvalidator.h>

namespace Tellico {

/**
 * @author Robby Stephenson
 */
class UPCValidator : public TQValidator {
Q_OBJECT
  TQ_OBJECT

public:
  UPCValidator(TQObject* parent, const char* name=0);

  virtual TQValidator::State validate(TQString& input, int& pos) const;
  virtual void fixup(TQString& input) const;

  void setCheckISBN(bool b) { m_checkISBN = b; }

signals:
  void signalISBN();

private:
  State decodeCat(TQString& str) const;

  bool m_checkISBN : 1;
  mutable bool m_isbn : 1;
};

} // end namespace
#endif
