/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLEXPORTER_H
#define HTMLEXPORTER_H

class TQCheckBox;

#include "exporter.h"
#include "../stringset.h"

#include <tqstringlist.h>

#include <libxml/xmlstring.h>

extern "C" {
  struct _xmlNode;
}

namespace Tellico {
  namespace Data {
    class Collection;
  }
  class XSLTHandler;

  namespace Export {

/**
 * @author Robby Stephenson
 */
class HTMLExporter : public Exporter {
Q_OBJECT
  TQ_OBJECT

public:
  HTMLExporter();
  HTMLExporter(Data::CollPtr coll);
  ~HTMLExporter();

  virtual bool exec();
  virtual void reset();
  virtual TQString formatString() const;
  virtual TQString fileFilter() const;

  virtual TQWidget* widget(TQWidget* parent, const char* name=0);
  virtual void readOptions(KConfig*);
  virtual void saveOptions(KConfig*);

  void setCollectionURL(const KURL& url) { m_collectionURL = url; m_links.clear(); }
  void setXSLTFile(const TQString& filename);
  void setPrintHeaders(bool printHeaders) { m_printHeaders = printHeaders; }
  void setPrintGrouped(bool printGrouped) { m_printGrouped = printGrouped; }
  void setMaxImageSize(int w, int h) { m_imageWidth = w; m_imageHeight = h; }
  void setGroupBy(const TQStringList& groupBy) { m_groupBy = groupBy; }
  void setSortTitles(const TQStringList& l)
    { m_sort1 = l[0]; m_sort2 = l[1]; m_sort3 = l[2]; }
  void setColumns(const TQStringList& columns) { m_columns = columns; }
  void setParseDOM(bool parseDOM) { m_parseDOM = parseDOM; reset(); }

  TQString text();

public slots:
  void slotCancel();

private:
  void setFormattingOptions(Data::CollPtr coll);
  void writeImages(Data::CollPtr coll);
  bool writeEntryFiles();
  KURL fileDir() const;
  TQString fileDirName() const;

  void parseDOM(_xmlNode* node);
  TQString handleLink(const TQString& link);
  const xmlChar* handleLink(const xmlChar* link);
  TQString analyzeInternalCSS(const TQString& string);
  const xmlChar* analyzeInternalCSS(const xmlChar* string);
  bool copyFiles();
  bool loadXSLTFile();
  void createDir();

  XSLTHandler* m_handler;
  bool m_printHeaders : 1;
  bool m_printGrouped : 1;
  bool m_exportEntryFiles : 1;
  bool m_cancelled : 1;
  bool m_parseDOM : 1;
  bool m_checkCreateDir : 1;
  int m_imageWidth;
  int m_imageHeight;

  TQWidget* m_widget;
  TQCheckBox* m_checkPrintHeaders;
  TQCheckBox* m_checkPrintGrouped;
  TQCheckBox* m_checkExportEntryFiles;
  TQCheckBox* m_checkExportImages;

  KURL m_collectionURL;
  TQString m_xsltFile;
  TQString m_xsltFilePath;
  TQString m_dataDir;
  TQStringList m_groupBy;
  TQString m_sort1;
  TQString m_sort2;
  TQString m_sort3;
  TQStringList m_columns;
  TQString m_entryXSLTFile;

  KURL::List m_files;
  TQMap<TQString, TQString> m_links;
  StringSet m_copiedFiles;
};

  } // end namespace
} // end namespace
#endif
