/***************************************************************************
    copyright            : (C) 2004-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef FREEDBIMPORTER_H
#define FREEDBIMPORTER_H

#include "importer.h"
#include "../datavectors.h"

#include <tqvaluevector.h>

class TQButtonGroup;
class TQRadioButton;
class KComboBox;

namespace Tellico {
  namespace Import {

/**
 * The FreeDBImporter class takes care of importing audio files.
 *
 * @author Robby Stephenson
 */
class FreeDBImporter : public Importer {
Q_OBJECT
  TQ_OBJECT

public:
  /**
   */
  FreeDBImporter();

  /**
   */
  virtual Data::CollPtr collection();
  /**
   */
  virtual TQWidget* widget(TQWidget* parent, const char* name=0);
  virtual bool canImport(int type) const;

public slots:
  void slotCancel();

private slots:
  void slotClicked(int id);

private:
  typedef TQValueVector<TQString> StringVector;
  struct CDText {
    friend class FreeDBImporter;
    TQString title;
    TQString artist;
    TQString message;
    StringVector trackTitles;
    StringVector trackArtists;
  };

  static TQValueList<uint> offsetList(const TQCString& drive, TQValueList<uint>& trackLengths);
  static CDText getCDText(const TQCString& drive);

  void readCDROM();
  void readCache();
  void readCDText(const TQCString& drive);

  Data::CollPtr m_coll;
  TQWidget* m_widget;
  TQButtonGroup* m_buttonGroup;
  TQRadioButton* m_radioCDROM;
  TQRadioButton* m_radioCache;
  KComboBox* m_driveCombo;
  bool m_cancelled : 1;
};

  } // end namespace
} // end namespace
#endif
