/***************************************************************************
    copyright            : (C) 2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

// this class is largely copied from kdelibs/knewstuff/provider.cpp
// which is Copyright (c) 2002 Cornelius Schumacher <schumacher@kde.org>
// and licensed under GPL v2, just like Tellico

#include "providerloader.h"
#include "../tellico_debug.h"
#include "../latin1literal.h"

#include <kio/job.h>
#include <knewstuff/provider.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kmessagebox.h>
#include <klocale.h>

#include <tqdom.h>

using Tellico::NewStuff::ProviderLoader;

ProviderLoader::ProviderLoader( TQWidget *parentWidget ) :
  mParentWidget( parentWidget ), mTryAlt(true)
{
  mProviders.setAutoDelete( true );
}

void ProviderLoader::load( const TQString &type, const TQString &providersList )
{
  mProviders.clear();
  mJobData.truncate(0);

//  myLog() << "ProviderLoader::load(): providersList: " << providersList << endl;

  KIO::TransferJob *job = KIO::get( KURL( providersList ), false, false );
  connect( job, TQT_SIGNAL( result( KIO::Job * ) ),
           TQT_SLOT( slotJobResult( KIO::Job * ) ) );
  connect( job, TQT_SIGNAL( data( KIO::Job *, const TQByteArray & ) ),
           TQT_SLOT( slotJobData( KIO::Job *, const TQByteArray & ) ) );
  connect( job, TQT_SIGNAL( percent (KIO::Job *, unsigned long) ),
           TQT_SIGNAL( percent (KIO::Job *, unsigned long) ) );

//  job->dumpObjectInfo();
}

void ProviderLoader::slotJobData( KIO::Job *, const TQByteArray &data )
{
  if ( data.size() == 0 ) return;
  TQCString str( data, data.size() + 1 );
  mJobData.append( TQString::fromUtf8( str ) );
}

void ProviderLoader::slotJobResult( KIO::Job *job )
{
  if ( job->error() ) {
    job->showErrorDialog( mParentWidget );
    if(mTryAlt && !mAltProvider.isEmpty()) {
      mTryAlt = false;
      load(TQString(), mAltProvider);
    } else {
      emit error();
    }
    return;
  }

  TQDomDocument doc;
  if ( !doc.setContent( mJobData ) ) {
    myDebug() << "ProviderLoader::slotJobResult() - error parsing providers list." << endl;
    if(mTryAlt && !mAltProvider.isEmpty()) {
      mTryAlt = false;
      load(TQString(), mAltProvider);
    } else {
      emit error();
    }
    return;
  }

  TQDomElement providers = doc.documentElement();
  TQDomNode n;
  for ( n = providers.firstChild(); !n.isNull(); n = n.nextSibling() ) {
    TQDomElement p = n.toElement();

    if ( p.tagName() == Latin1Literal("provider") ) {
      mProviders.append( new KNS::Provider( p ) );
    }
  }

  emit providersLoaded( &mProviders );
}

#include "providerloader.moc"
