/***************************************************************************
    copyright            : (C) 2007 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_LISTVIEWCOMPARISON_H
#define TELLICO_LISTVIEWCOMPARISON_H

#include "datavectors.h"

#include <tqregexp.h>

class TQStringList;
class TQIconViewItem;

namespace Tellico {
  namespace GUI {
    class ListViewItem;
  }

class ListViewComparison {
public:
  ListViewComparison(Data::ConstFieldPtr field);
  virtual ~ListViewComparison() {}

  const TQString& fieldName() const { return m_fieldName; }

  virtual int compare(int col, const GUI::ListViewItem* item1, const GUI::ListViewItem* item2, bool asc);
  virtual int compare(const TQIconViewItem* item1, const TQIconViewItem* item2);

  static ListViewComparison* create(Data::FieldPtr field);
  static ListViewComparison* create(Data::ConstFieldPtr field);

protected:
  virtual int compare(const TQString& str1, const TQString& str2) = 0;

private:
  TQString m_fieldName;
};

class StringComparison : public ListViewComparison {
public:
  StringComparison(Data::ConstFieldPtr field);

protected:
  virtual int compare(const TQString& str1, const TQString& str2);
};

class TitleComparison : public ListViewComparison {
public:
  TitleComparison(Data::ConstFieldPtr field);

protected:
  virtual int compare(const TQString& str1, const TQString& str2);
};

class NumberComparison : public ListViewComparison {
public:
  NumberComparison(Data::ConstFieldPtr field);

protected:
  virtual int compare(const TQString& str1, const TQString& str2);
};

class LCCComparison : public StringComparison {
public:
  LCCComparison(Data::ConstFieldPtr field);

protected:
  virtual int compare(const TQString& str1, const TQString& str2);

private:
  int compareLCC(const TQStringList& cap1, const TQStringList& cap2) const;
  TQRegExp m_regexp;
};

class PixmapComparison : public ListViewComparison {
public:
  PixmapComparison(Data::ConstFieldPtr field);

  virtual int compare(int col, const GUI::ListViewItem* item1, const GUI::ListViewItem* item2, bool asc);
  virtual int compare(const TQIconViewItem* item1, const TQIconViewItem* item2);

protected:
  virtual int compare(const TQString&, const TQString&) { return 0; }
};

class DependentComparison : public StringComparison {
public:
  DependentComparison(Data::ConstFieldPtr field);

  virtual int compare(int col, const GUI::ListViewItem* item1, const GUI::ListViewItem* item2, bool asc);
  virtual int compare(const TQIconViewItem* item1, const TQIconViewItem* item2);

private:
  TQPtrList<ListViewComparison> m_comparisons;
};

class ISODateComparison : public ListViewComparison {
public:
  ISODateComparison(Data::ConstFieldPtr field);

protected:
  virtual int compare(const TQString& str1, const TQString& str2);
};

}
#endif
