/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICODATEWIDGET_H
#define TELLICODATEWIDGET_H

#include <tqspinbox.h>
#include <tqdatetime.h>

class KComboBox;
class KPushButton;
class KDatePicker;

class TQVBox;
class TQString;

namespace Tellico {
  namespace GUI {

class SpinBox : public TQSpinBox {
Q_OBJECT
  TQ_OBJECT

public:
  SpinBox(int min, int max, TQWidget *parent);
};

/**
 * @author Robby Stephenson
 */
class DateWidget : public TQWidget {
Q_OBJECT
  TQ_OBJECT

public:
  DateWidget(TQWidget* parent, const char* name = 0);
  ~DateWidget() {}

  TQDate date() const;
  TQString text() const;
  void setDate(const TQDate& date);
  void setDate(const TQString& date);
  void clear();

signals:
  void signalModified();

private slots:
  void slotDateChanged();
  void slotShowPicker();
  void slotDateSelected(TQDate newDate);
  void slotDateEntered(TQDate newDate);

private:
  SpinBox* m_daySpin;
  KComboBox* m_monthCombo;
  SpinBox* m_yearSpin;
  KPushButton* m_dateButton;

  TQVBox* m_frame;
  KDatePicker* m_picker;
};

  } // end namespace
} // end namespace
#endif
