/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef FETCHCONFIGWIDGET_H
#define FETCHCONFIGWIDGET_H

#include "../datavectors.h"

#include <tqwidget.h>
#include <tqdict.h>
#include <tqcheckbox.h>

class KConfigGroup;
class TQStringList;

namespace Tellico {
  namespace Fetch {

/**
 * @author Robby Stephenson
 */
class ConfigWidget : public TQWidget {
Q_OBJECT
  TQ_OBJECT

public:
  ConfigWidget(TQWidget* parent);
  virtual ~ConfigWidget() {}

  void setAccepted(bool accepted_) { m_accepted = accepted_; }
  bool shouldSave() const { return m_modified && m_accepted; }
  /**
   * Saves any configuration options. The config group must be
   * set before calling this function.
   *
   * @param config_ The KConfig pointer
   */
  virtual void saveConfig(KConfigGroup& config) = 0;
  /**
   * Called when a fetcher data source is removed. Useful for any cleanup work necessary.
   * The ExecExternalFetcher might need to remove the script, for example.
   * Because of the way the ConfigDialog is setup, easier to have that in the ConfigWidget
   * class than in the Fetcher class itself
   */
  virtual void removed() {}
  virtual TQString preferredName() const = 0;

signals:
  void signalName(const TQString& name);

public slots:
  void slotSetModified(bool modified_ = true) { m_modified = modified_; }

protected:
  TQWidget* optionsWidget() { return m_optionsWidget; }
  void addFieldsWidget(const StringMap& customFields, const TQStringList& fieldsToAdd);
  void saveFieldsConfig(KConfigGroup& config) const;

private:
  bool m_modified;
  bool m_accepted;
  TQWidget* m_optionsWidget;
  TQDict<TQCheckBox> m_fields;
};

  }
}

#endif
