/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef BORROWERDIALOG_H
#define BORROWERDIALOG_H

class KLineEdit;

#include "borrower.h"

#include <kdialogbase.h>

#include <klistview.h>
#include <tqdict.h>

namespace KABC {
  class Addressee;
}

namespace Tellico {

/**
 * @author Robby Stephenson
 */
class BorrowerDialog : public KDialogBase {
Q_OBJECT
  TQ_OBJECT

public:
  static Data::BorrowerPtr getBorrower(TQWidget* parent);

private slots:
  void selectItem(const TQString& name);
  void updateEdit(TQListViewItem* item);
  void slotLoadAddressBook();

private:
  /**
   * The constructor sets up the dialog.
   *
   * @param parent A pointer to the parent widget
   * @param name The widget name
   */
  BorrowerDialog(TQWidget* parent, const char* name=0);
  Data::BorrowerPtr borrower();

  TQString m_uid;
  KListView* m_listView;
  KLineEdit* m_lineEdit;
  TQDict<KListViewItem> m_itemDict;

class Item : public KListViewItem {
public:
  Item(KListView* parent, const KABC::Addressee& addressee);
  Item(KListView* parent, const Data::Borrower& borrower);
  const TQString& uid() const { return m_uid; }

private:
  TQString m_uid;
};

};

} // end namespace
#endif
