
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_PROPERTYBOX_H_
#define _RG_PROPERTYBOX_H_

#include <tqsize.h>
#include <tqstring.h>
#include <tqwidget.h>


class TQPaintEvent;


namespace Rosegarden
{



/**
 * We use a ControlBox to help modify events on the ruler - set tools etc.
 * and provide extra information or options.
 *
 */
class PropertyBox : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

public:
    PropertyBox(TQString label,
               int width,
               int height,
               TQWidget *parent=0,
               const char *name = 0);

    virtual TQSize sizeHint() const;
    virtual TQSize minimumSizeHint() const;

protected:
    virtual void paintEvent(TQPaintEvent *);

    //--------------- Data members ---------------------------------

    TQString m_label;
    int     m_width;
    int     m_height;
};


}

#endif
