
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_PROGRESSREPORTER_H_
#define _RG_PROGRESSREPORTER_H_

#include <tqobject.h>




namespace Rosegarden
{



class ProgressReporter : public TQObject
{
    Q_OBJECT
  TQ_OBJECT
public:
    ProgressReporter(TQObject* parent, const char* name = 0);

    // exception class for cancellations
    class Cancelled { };

protected:
    /**
     * Call this at appropriate times if you know TQt isn't in the stack
     */
    void throwIfCancelled();

    /*
      We have to use these accessors rather than throwing directly
      from slotCancel() because TQt is generally compiled without
      exception support, so we can't throw from a slot.
    */
    bool isOperationCancelled() const { return m_isCancelled; }
//     void resetOperationCancelledState() { m_isCancelled = false; }

protected slots:
     virtual void slotCancel();

signals:
    /// Report progress
    void setProgress(int);
    void incrementProgress(int);
    void setOperationName(TQString);

protected:
    //--------------- Data members ---------------------------------
    bool m_isCancelled;
};



}

#endif
