/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "MatrixEraser.h"
#include "misc/Debug.h"

#include <klocale.h>
#include <kstddirs.h>
#include "base/ViewElement.h"
#include "commands/matrix/MatrixEraseCommand.h"
#include "gui/general/EditTool.h"
#include "MatrixStaff.h"
#include "MatrixTool.h"
#include "MatrixView.h"
#include <kaction.h>
#include <kglobal.h>
#include <tqiconset.h>
#include <tqstring.h>


namespace Rosegarden
{

MatrixEraser::MatrixEraser(MatrixView* parent)
        : MatrixTool("MatrixEraser", parent),
        m_currentStaff(0)
{
    TQString pixmapDir = KGlobal::dirs()->findResource("appdata", "pixmaps/");
    TQCanvasPixmap pixmap(pixmapDir + "/toolbar/select.xpm");
    TQIconSet icon = TQIconSet(pixmap);

    new KAction(i18n("Switch to Select Tool"), icon, 0, this,
                TQT_SLOT(slotSelectSelected()), actionCollection(),
                "select");

    new KAction(i18n("Switch to Draw Tool"), "pencil", 0, this,
                TQT_SLOT(slotDrawSelected()), actionCollection(),
                "draw");

    new KAction(i18n("Switch to Move Tool"), "move", 0, this,
                TQT_SLOT(slotMoveSelected()), actionCollection(),
                "move");

    pixmap.load(pixmapDir + "/toolbar/resize.xpm");
    icon = TQIconSet(pixmap);
    new KAction(i18n("Switch to Resize Tool"), icon, 0, this,
                TQT_SLOT(slotResizeSelected()), actionCollection(),
                "resize");

    createMenu("matrixeraser.rc");
}

void MatrixEraser::handleLeftButtonPress(timeT,
        int,
        int staffNo,
        TQMouseEvent*,
        ViewElement* el)
{
    MATRIX_DEBUG << "MatrixEraser::handleLeftButtonPress : el = "
    << el << endl;

    if (!el)
        return ; // nothing to erase

    m_currentStaff = m_mParentView->getStaff(staffNo);

    MatrixEraseCommand* command =
        new MatrixEraseCommand(m_currentStaff->getSegment(), el->event());

    m_mParentView->addCommandToHistory(command);

    m_mParentView->update();
}

void MatrixEraser::ready()
{
    m_mParentView->setCanvasCursor(TQt::pointingHandCursor);
    setBasicContextHelp();
}

void MatrixEraser::setBasicContextHelp()
{
    setContextHelp(i18n("Click on a note to delete it"));
}

const TQString MatrixEraser::ToolName    = "eraser";

}
