
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_IDENTIFYTEXTCODECDIALOG_H_
#define _RG_IDENTIFYTEXTCODECDIALOG_H_

#include <string>
#include <kdialogbase.h>
#include <deque>


class TQWidget;
class TQLabel;


namespace Rosegarden
{



class IdentifyTextCodecDialog : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT
    
public:
    IdentifyTextCodecDialog(TQWidget *parent, std::string text);

    std::string getCodec() const { return m_codec; }

protected slots:
    void slotCodecSelected(int);

protected:
    std::string m_text;
    std::string m_codec;
    std::deque<std::string> m_codecs;
    TQLabel *m_example;
};


/*
 * Creates a small dialog box containing a PitchChooser widget.  The
 * info paramter provides extra information as a reminder what this particular
 * picker is for, eg. Highest, Lowest, From, To
 */

}

#endif
