/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "ConfigureDialog.h"
#include <tqlayout.h>

#include <klocale.h>
#include "ConfigureDialogBase.h"
#include "document/RosegardenGUIDoc.h"
#include "gui/configuration/GeneralConfigurationPage.h"
#include "gui/configuration/NotationConfigurationPage.h"
#include "gui/configuration/AudioConfigurationPage.h"
#include "gui/configuration/MIDIConfigurationPage.h"
#include <kconfig.h>
#include <kdialogbase.h>
#include <kstddirs.h>
#include <tqstring.h>
#include <tqwidget.h>


namespace Rosegarden
{

static TQPixmap loadIcon(const char *name)
{
    TQString pixmapDir = KGlobal::dirs()->findResource("appdata", "pixmaps/");
    TQString fileBase = pixmapDir + "/misc/";
    fileBase += name;
    if (TQFile(fileBase + ".png").exists()) {
        return TQPixmap(fileBase + ".png");
    } else if (TQFile(fileBase + ".xpm").exists()) {
        return TQPixmap(fileBase + ".xpm");
    }
    TQPixmap pmap = KGlobal::instance()->iconLoader()
        ->loadIcon(TQString::fromLatin1(name), KIcon::NoGroup, KIcon::SizeMedium);
    return pmap;
}


ConfigureDialog::ConfigureDialog(RosegardenGUIDoc *doc,
                                 KConfig* cfg,
                                 TQWidget *parent,
                                 const char *name)
        : ConfigureDialogBase(parent, i18n("Configure Rosegarden"), name)
{
    TQWidget *pageWidget = 0;
    TQVBoxLayout *vlay = 0;
    ConfigurationPage* page = 0;

    // General Page
    //
    pageWidget = addPage(GeneralConfigurationPage::iconLabel(),
                         GeneralConfigurationPage::title(),
                         loadIcon(GeneralConfigurationPage::iconName().ascii()));
    vlay = new TQVBoxLayout(pageWidget, 0, spacingHint());
    page = new GeneralConfigurationPage(doc, cfg, pageWidget);
    vlay->addWidget(page);
    page->setPageIndex(pageIndex(pageWidget));
    m_configurationPages.push_back(page);

    connect(page, TQT_SIGNAL(updateAutoSaveInterval(unsigned int)),
            this, TQT_SIGNAL(updateAutoSaveInterval(unsigned int)));
    connect(page, TQT_SIGNAL(updateSidebarStyle(unsigned int)),
            this, TQT_SIGNAL(updateSidebarStyle(unsigned int)));

    pageWidget = addPage(MIDIConfigurationPage::iconLabel(),
                         MIDIConfigurationPage::title(),
                         loadIcon(MIDIConfigurationPage::iconName().ascii()));
    vlay = new TQVBoxLayout(pageWidget, 0, spacingHint());
    page = new MIDIConfigurationPage(doc, cfg, pageWidget);
    vlay->addWidget(page);
    page->setPageIndex(pageIndex(pageWidget));
    m_configurationPages.push_back(page);

    pageWidget = addPage(AudioConfigurationPage::iconLabel(),
                         AudioConfigurationPage::title(),
                         loadIcon(AudioConfigurationPage::iconName().ascii()));
    vlay = new TQVBoxLayout(pageWidget, 0, spacingHint());
    page = new AudioConfigurationPage(doc, cfg, pageWidget);
    vlay->addWidget(page);
    page->setPageIndex(pageIndex(pageWidget));
    m_configurationPages.push_back(page);

    // Notation Page
    pageWidget = addPage(NotationConfigurationPage::iconLabel(),
                         NotationConfigurationPage::title(),
                         loadIcon(NotationConfigurationPage::iconName().ascii()));
    vlay = new TQVBoxLayout(pageWidget, 0, spacingHint());
    page = new NotationConfigurationPage(cfg, pageWidget);
    vlay->addWidget(page);
    page->setPageIndex(pageIndex(pageWidget));
    m_configurationPages.push_back(page);
}

}
#include "ConfigureDialog.moc"
