
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_GENERALCONFIGURATIONPAGE_H_
#define _RG_GENERALCONFIGURATIONPAGE_H_

#include "TabbedConfigurationPage.h"
#include "gui/editors/eventlist/EventView.h"
#include <tqstring.h>
#include <tqcheckbox.h>
#include <tqspinbox.h>
#include <tqcombobox.h>
#include <tqlineedit.h>
#include <klocale.h>
#include <kiconloader.h>

class TQWidget;
class KConfig;


namespace Rosegarden
{

class RosegardenGUIDoc;


/**
 * General Rosegarden Configuration page
 *
 * (application-wide settings)
 */
class GeneralConfigurationPage : public TabbedConfigurationPage
{
    Q_OBJECT
  TQ_OBJECT

public:
    enum DoubleClickClient
    {
        NotationView,
        MatrixView,
        EventView
    };

    enum NoteNameStyle
    { 
        American,
        Local
    };

    GeneralConfigurationPage(RosegardenGUIDoc *doc,
                             KConfig *cfg,
                             TQWidget *parent=0, const char *name=0);

    virtual void apply();

    static TQString iconLabel() { return i18n("General"); }
    static TQString title()     { return i18n("General Configuration"); }
    static TQString iconName()  { return "configure-general"; }

signals:
    void updateAutoSaveInterval(unsigned int);
    void updateSidebarStyle(unsigned int);

protected slots:
    void slotShowStatus();

protected:
    int getCountInSpin()            { return m_countIn->value(); }
    int getDblClickClient()         { return m_client->currentItem(); }
    int getNoteNameStyle() { return m_nameStyle->currentItem(); }

    //--------------- Data members ---------------------------------
    RosegardenGUIDoc* m_doc;

    TQComboBox* m_client;
    TQSpinBox*  m_countIn;
    TQCheckBox* m_toolContextHelp;
    TQCheckBox* m_backgroundTextures;
    TQCheckBox* m_notationBackgroundTextures;
    TQCheckBox* m_matrixBackgroundTextures;
    TQComboBox *m_autoSave;
    TQComboBox* m_nameStyle;
    TQComboBox* m_sidebarStyle;
    TQComboBox* m_globalStyle;
    TQCheckBox *m_jackTransport;

};




}

#endif
