/***************************************************************************
 *   Copyright (C) 2007 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef MAIN_H
#define MAIN_H

#include "common/global/pfile.h"
#include "devices/base/hex_buffer.h"
#include "common/cli/cli_main.h"
namespace Device { class Data; class Memory; }
namespace Coff { class Symbol; class AuxSymbol; }

namespace CLI
{
//----------------------------------------------------------------------------
enum CommandProperty { NoCommandProperty = 0, NeedSource = 1, NeedDestination = 2, NeedDevice = 4 };
TQ_DECLARE_FLAGS(CommandProperties, CommandProperty)
TQ_DECLARE_OPERATORS_FOR_FLAGS(CommandProperties)

//----------------------------------------------------------------------------
class Main : public MainBase
{
Q_OBJECT
  TQ_OBJECT
public:
  Main();
  virtual ~Main();

private:
  const Device::Data *_device;
  PURL::Url           _source, _dest;

  virtual ExitCode prepareCommand(const TQString &command);
  virtual ExitCode executeCommand(const TQString &command);
  virtual ExitCode prepareRun(bool &interactive);
  virtual ExitCode executeSetCommand(const TQString &property, const TQString &value);
  ExitCode executeCommandArchive(const TQString &command, Log::KeyList &keys);
  ExitCode executeCommandObject(const TQString &command, Log::KeyList &keys);
  virtual TQString executeGetCommand(const TQString &property);
  virtual ExitCode list(const TQString &listName);
  ExitCode deviceList();
  static TQString prettyAuxSymbol(const Coff::AuxSymbol &aux);
  static TQString prettySymbol(const Coff::Symbol &sym);
};

} // namespace

#endif
