/***************************************************************************
 *   Copyright (C) 2007 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef LIST_CONTAINER_H
#define LIST_CONTAINER_H

#include <kpopupmenu.h>
#include <klistview.h>

//----------------------------------------------------------------------------
class ListContainer
{
public:
  virtual ~ListContainer() {}
  virtual ListContainer *appendBranch(const TQString &title) = 0;
  enum ItemState { Normal, Checked, UnChecked, Disabled };
  void appendItem(const TQString &label, uint id, ItemState state) { appendItem(TQPixmap(), label, id, state); }
  virtual void appendItem(const TQPixmap &icon, const TQString &label, uint id, ItemState state) = 0;
};

//----------------------------------------------------------------------------
class PopupContainer : public KPopupMenu, public ListContainer
{
Q_OBJECT
  TQ_OBJECT
public:
  PopupContainer(const TQString &title, TQWidget *parent = 0, const char *name = 0);
  virtual ListContainer *appendBranch(const TQString &title);
  virtual ListContainer *appendBranch(const TQPixmap &icon, const TQString &title);
  virtual void appendItem(const TQPixmap &icon, const TQString &label, uint id, ItemState state);
};

//----------------------------------------------------------------------------
class ListViewItemContainer : public KListViewItem, public ListContainer
{
public:
  ListViewItemContainer(const TQString &title, KListView *parent);
  ListViewItemContainer(const TQString &title, ListViewItemContainer *parent);
  virtual ~ListViewItemContainer();
  void setColumn(uint column) { _column = column; }
  virtual ListContainer *appendBranch(const TQString &title);
  virtual void appendItem(const TQPixmap &icon, const TQString &label, uint id, ItemState state);
  int id(const TQListViewItem* item) const; // -1 if not known

private:
  ListViewItemContainer *_parent;
  uint _column;
  TQMap<const TQListViewItem *, uint> *_ids;
};

#endif
