/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef DIALOG_H
#define DIALOG_H

#include <tqlayout.h>
#include <kdialogbase.h>
#include <klistview.h>

//-----------------------------------------------------------------------------
class Dialog : public KDialogBase
{
Q_OBJECT
  TQ_OBJECT
public:
  Dialog(TQWidget *parent, const char *name, bool modal,
         const TQString &caption, int buttonMask, ButtonCode defaultButton, bool separator,
         const TQSize &defaultSize = TQSize());
  Dialog(DialogType type, const TQString &caption,
         int buttonMask, ButtonCode defaultButton, TQWidget *parent, const char *name,
         bool modal, bool separator, const TQSize &defaultSize = TQSize());
  virtual ~Dialog();

private slots:
  void updateSize();

private:
  TQSize _defaultSize;
};

//-----------------------------------------------------------------------------
class TreeListDialog : public Dialog
{
Q_OBJECT
  TQ_OBJECT
public:
  TreeListDialog(TQWidget *parent, const char *name, bool modal,
                 const TQString &caption, int buttonMask, ButtonCode defaultButton, bool separator);
  TQWidget *addPage(const TQStringList &labels);
  void showPage(TQWidget *page);
  int activePageIndex() const;
  int pageIndex(TQWidget *page) const;

protected slots:
  virtual void currentChanged(TQListViewItem *item);
  void pageDestroyed(TQObject *page);

protected:
  TQFrame       *_frame;
  KListView    *_listView;
  TQHBoxLayout  *_titleBox;
  TQLabel       *_label;
  TQWidgetStack *_stack;

 class Item : public KListViewItem {
  public:
    Item(const TQString &label, TQWidget *page, const TQString &title, TQListView *listview);
    Item(const TQString &label, TQWidget *page, const TQString &title, TQListViewItem *item);
    TQWidget *_page;
    TQString  _title;
  };
};

//-----------------------------------------------------------------------------
class TextEditorDialog : public Dialog
{
Q_OBJECT
  TQ_OBJECT
public:
  TextEditorDialog(const TQString &text, const TQString &caption,
                   bool wrapAtWidgetWidth, TQWidget *parent);
};

#endif
