/***************************************************************************
 *   Copyright (C) 2005-2006 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef XML_DATA_FILE_H
#define XML_DATA_FILE_H

#include <tqdom.h>

#include "common/global/purl.h"

class XmlDataFile
{
public:
  XmlDataFile(const PURL::Url &url, const TQString &name);
  virtual ~XmlDataFile() {}
  PURL::Url url() const { return _url; }
  virtual bool load(TQString &error);
  bool save(TQString &error) const;

  TQString value(const TQString &group, const TQString &key, const TQString &defaultValue) const;
  void setValue(const TQString &group, const TQString &key, const TQString &value);
  TQStringList listValues(const TQString &group, const TQString &key, const TQStringList &defaultValues) const;
  void setListValues(const TQString &group, const TQString &key, const TQStringList &values);
  void appendListValue(const TQString &group, const TQString &key, const TQString &value);
  void removeListValue(const TQString &group, const TQString &key, const TQString &value);
  void clearList(const TQString &group, const TQString &key);

protected:
  PURL::Url _url;

private:
  TQString      _name;
  TQDomDocument _document;

  TQDomElement findChildElement(TQDomElement element, const TQString &tag) const;
  TQDomElement createChildElement(TQDomElement element, const TQString &tag);
  void removeChilds(TQDomNode node) const;
};

#endif
