#ifndef _H_URLDLG
#define _H_URLDLG

//
//   This file is part of the KVIrc irc client distribution
//   Copyright (C) 1999-2000 Andrea Parrella (anandrea@iname.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//


#include <tqdialog.h>
#include <tqlayout.h>
#include "kvi_tal_listview.h"
#include <tqstring.h>
#include <tqpushbutton.h>
#include <tqfile.h>
#ifdef COMPILE_USE_QT4
	#include <tq3textstream.h>
#else
	#include <tqtextstream.h>
#endif
#include <tqcheckbox.h>
#include "kvi_tal_listbox.h"
#include <tqmenubar.h>
#include <tqinputdialog.h>
#include <tqtoolbutton.h>
#include <tqiconset.h>

#include "kvi_locale.h"
#include "kvi_config.h"
#include "kvi_irctoolbar.h"
#include "kvi_imagelib.h"
#include "kvi_window.h"
#include "kvi_tal_menubar.h"
#include "kvi_mextoolbar.h"
#include "kvi_styled_controls.h"

#include <tqpixmap.h>

typedef struct _KviUrl
{
	TQString url;
	TQString window;
	int count;
	TQString timestamp;
} KviUrl;


class UrlDialog : public KviWindow
{
	Q_OBJECT
  TQ_OBJECT
public:
	UrlDialog(KviPointerList<KviUrl> *g_pList);
	~UrlDialog();
private:
	KviTalMenuBar *m_pMenuBar;
	KviTalPopupMenu *m_pListPopup;	// dynamic popup menu
	KviStr m_szUrl;			// used to pass urls to sayToWin slot
protected:
	TQPixmap *myIconPtr();
	void resizeEvent(TQResizeEvent *);
public:
	KviTalListView *m_pUrlList;
	void addUrl(TQString url, TQString window, TQString count, TQString timestamp);
//	void saveProperties();
protected slots:
	void config();
	void help();
	void saveList();
	void loadList();
	void clear();
	void close_slot();
	void remove();
	void findtext();
	void dblclk_url(KviTalListViewItem *item);
	void popup(KviTalListViewItem *item, const TQPoint &p, int col);
	void sayToWin(int);
};

class BanFrame : public TQFrame
{
	Q_OBJECT
  TQ_OBJECT
public:
	BanFrame(TQWidget *parent=0, const char *name=0, bool banEnable = false);
	~BanFrame();
	void saveBans();
private:
	KviStyledCheckBox *m_pEnable;
	KviTalListBox *m_pBanList;
	TQPushButton *m_pAddBtn;
	TQPushButton *m_pRemoveBtn;
protected slots:
	void enableClicked();
	void addBan();
	void removeBan();
};

#define cbnum 2

class ConfigDialog : public TQDialog
{
	Q_OBJECT
  TQ_OBJECT
public:
	ConfigDialog();
	~ConfigDialog();
private:
	KviStyledCheckBox *cb[cbnum];
	BanFrame *m_pBanFrame;
	void closeEvent(TQCloseEvent *);
protected slots:
	void acceptbtn();
	void discardbtn();
};

#include "kvi_kvs_action.h"

class KviUrlAction : public KviKvsAction
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviUrlAction(TQObject * pParent);
	~KviUrlAction();
protected:
	TQPixmap * m_pBigIcon;
	TQPixmap * m_pSmallIcon;
public:
	virtual TQPixmap * bigIcon();
	virtual TQPixmap * smallIcon();
};

#endif
