#ifndef _PACKTHEMEDIALOG_H_
#define _PACKTHEMEDIALOG_H_
//=============================================================================
//
//   File : packthemedialog.h
//   Created on Wed 03 Jan 2007 01:11:44 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC Client distribution
//   Copyright (C) 2007 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_pointerlist.h"
#include "kvi_theme.h"

#include <tqdialog.h>
#include <kvi_tal_wizard.h>

class TQLineEdit;
class KviTalTextEdit;
class TQLabel;
class TQMultiLineEdit;
class KviFileSelector;


class KviPackThemeDialog : public KviTalWizard
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviPackThemeDialog(TQWidget * pParent,KviPointerList<KviThemeInfo> * pThemeInfoList);
	virtual ~KviPackThemeDialog();
protected:
	TQString m_szImagePath;
	KviFileSelector * m_pImageSelector;
	TQString m_szPackagePath;
	KviFileSelector * m_pPathSelector;
	TQLabel * m_pImageLabel;
	KviPointerList<KviThemeInfo> * m_pThemeInfoList;
	TQLineEdit * m_pPackageNameEdit;
	KviTalTextEdit * m_pPackageDescriptionEdit;
	TQLineEdit * m_pPackageVersionEdit;
	TQLineEdit * m_pPackagerNameEdit;
	TQWidget * m_pImageSelectionPage;
protected:
	virtual void accept();
	bool packTheme();
protected slots:
	void imageSelectionChanged(const TQString &szImagePath);
};

#endif //!_PACKTHEMEDIALOG_H_
